/*
 * Decompiled with CFR 0.152.
 */
package com.alazeprt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DependencyDownloader {
    private final String dependency;
    private final String centralUrl;

    public DependencyDownloader(String dependency) {
        this.dependency = dependency;
        this.centralUrl = "https://repo.maven.apache.org/maven2/";
    }

    public DependencyDownloader(String dependency, String centralUrl) {
        this.dependency = dependency;
        if (!((String)centralUrl).endsWith("/")) {
            centralUrl = (String)centralUrl + "/";
        }
        this.centralUrl = centralUrl;
    }

    public DependencyDownloader(String groupId, String artifactId, String version) {
        this.dependency = groupId + ":" + artifactId + ":" + version;
        this.centralUrl = "https://repo.maven.apache.org/maven2/";
    }

    private String parseDependency() {
        String[] strings = this.dependency.split(":");
        String packageUrl = strings[0].replace(".", "/");
        return this.centralUrl + packageUrl + "/" + strings[1] + "/" + strings[2];
    }

    public String getDependency() {
        return this.dependency;
    }

    public static List<DependencyDownloader> getDependencies(List<DependencyDownloader> list) throws IOException, XmlPullParserException {
        ArrayList<DependencyDownloader> dependencies = new ArrayList<DependencyDownloader>();
        for (DependencyDownloader dependencyDownloader1 : list) {
            if (dependencyDownloader1.getDependency().split(":")[1].equals("junit") || dependencyDownloader1.getDependency().split(":")[1].equals("junit-jupiter-api")) continue;
            URL pomUrl = new URL(dependencyDownloader1.parseDependency() + "/" + dependencyDownloader1.getDependency().split(":")[1] + "-" + dependencyDownloader1.getDependency().split(":")[2] + ".pom");
            HttpURLConnection connection = (HttpURLConnection)pomUrl.openConnection();
            InputStream in = connection.getInputStream();
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(in);
            in.close();
            connection.disconnect();
            if (model.getDependencies().isEmpty()) {
                dependencies.add(dependencyDownloader1);
                continue;
            }
            ArrayList<DependencyDownloader> subDependencies = new ArrayList<DependencyDownloader>();
            for (Dependency mavenDependency : model.getDependencies()) {
                DependencyDownloader subDependencyDownloader;
                if (mavenDependency.getArtifactId().equals("junit") || mavenDependency.getArtifactId().equals("junit-jupiter-api")) continue;
                ArrayList<DependencyDownloader> list1 = new ArrayList<DependencyDownloader>();
                list1.addAll(subDependencies);
                list1.addAll(dependencies);
                list1.addAll(list);
                if (mavenDependency.getVersion() == null || mavenDependency.getVersion().startsWith("${")) {
                    if (mavenDependency.getGroupId().startsWith("${")) {
                        version = DependencyDownloader.getSameVersion(list1, mavenDependency.getArtifactId(), mavenDependency.getArtifactId());
                        subDependencyDownloader = new DependencyDownloader(mavenDependency.getArtifactId(), mavenDependency.getArtifactId(), version);
                    } else {
                        version = DependencyDownloader.getSameVersion(list1, mavenDependency.getGroupId(), mavenDependency.getArtifactId());
                        subDependencyDownloader = new DependencyDownloader(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), version);
                    }
                } else if (mavenDependency.getGroupId().startsWith("${")) {
                    version = DependencyDownloader.getSameVersion(list1, mavenDependency.getArtifactId(), mavenDependency.getArtifactId());
                    subDependencyDownloader = new DependencyDownloader(mavenDependency.getArtifactId(), mavenDependency.getArtifactId(), version);
                } else {
                    version = DependencyDownloader.getSameVersion(list1, mavenDependency.getGroupId(), mavenDependency.getArtifactId());
                    subDependencyDownloader = new DependencyDownloader(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), version);
                }
                subDependencies.add(subDependencyDownloader);
            }
            dependencies.addAll(subDependencies);
        }
        dependencies.addAll(list);
        return dependencies;
    }

    private static String getSameVersion(List<DependencyDownloader> subDependencies, String groupId, String artifactId) throws IOException {
        String version = DependencyDownloader.getLatestVersion(groupId, artifactId);
        for (DependencyDownloader dependencyDownloader2 : subDependencies) {
            if (!dependencyDownloader2.getDependency().split(":")[0].equals(groupId) || !DependencyDownloader.versionFound(groupId, artifactId, dependencyDownloader2.getDependency().split(":")[2])) continue;
            version = dependencyDownloader2.getDependency().split(":")[2];
            break;
        }
        return version;
    }

    public static void downloadAll(List<DependencyDownloader> list, String outputFolder, int threads) throws IOException {
        File folder = new File((String)outputFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!((String)outputFolder).endsWith("/")) {
            outputFolder = (String)outputFolder + "/";
        }
        for (DependencyDownloader dependencyDownloader1 : list) {
            if (new File((String)outputFolder + dependencyDownloader1.getDependency().split(":")[1] + "-" + dependencyDownloader1.getDependency().split(":")[2] + ".jar").exists()) continue;
            Object fileUrl = dependencyDownloader1.parseDependency();
            fileUrl = (String)fileUrl + "/" + dependencyDownloader1.getDependency().split(":")[1] + "-" + dependencyDownloader1.getDependency().split(":")[2] + ".jar";
            System.out.println("Downloading " + dependencyDownloader1.getDependency().split(":")[1] + "-" + dependencyDownloader1.getDependency().split(":")[2] + ".jar");
            DependencyDownloader.downloadFiles((String)fileUrl, (String)outputFolder + dependencyDownloader1.getDependency().split(":")[1] + "-" + dependencyDownloader1.getDependency().split(":")[2] + ".jar", threads);
        }
    }

    private static void downloadFiles(String fileUrl, String outputFilePath, int numThreads) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int fileSize = connection.getContentLength();
        connection.disconnect();
        int chunkSize = fileSize / numThreads;
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            int startByte = i * chunkSize;
            int endByte = i == numThreads - 1 ? fileSize - 1 : (i + 1) * chunkSize - 1;
            threads[i] = new Thread(new DownloadThread(fileUrl, startByte, endByte, outputFilePath));
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getLatestVersion(String groupId, String artifactId) throws IOException {
        String mavenMetadataUrl = "https://repo.maven.apache.org/maven2/" + groupId.replace(".", "/") + "/" + artifactId + "/maven-metadata.xml";
        URL url = new URL(mavenMetadataUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        Pattern pattern = Pattern.compile("<latest>(.*?)</latest>");
        Matcher matcher = pattern.matcher(response.toString());
        if (matcher.find()) {
            return matcher.group(1);
        }
        Pattern pattern1 = Pattern.compile("<version>(.*?)</version>");
        Matcher matcher1 = pattern1.matcher(response.toString());
        if (matcher1.find()) {
            return matcher1.group(1);
        }
        return null;
    }

    private static boolean versionFound(String groupId, String artifactId, String version) throws IOException {
        String mavenMetadataUrl = "https://repo.maven.apache.org/maven2/" + groupId.replace(".", "/") + "/" + artifactId + "/maven-metadata.xml";
        URL url = new URL(mavenMetadataUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        if (response.isEmpty()) {
            return false;
        }
        return response.toString().contains(version);
    }

    private static class DownloadThread
    implements Runnable {
        private final String fileUrl;
        private final int startByte;
        private final int endByte;
        private final String outputFilePath;

        private DownloadThread(String fileUrl, int startByte, int endByte, String outputFilePath) {
            this.fileUrl = fileUrl;
            this.startByte = startByte;
            this.endByte = endByte;
            this.outputFilePath = outputFilePath;
        }

        @Override
        public void run() {
            try {
                URL url = new URL(this.fileUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Range", "bytes=" + this.startByte + "-" + this.endByte);
                try (InputStream in = connection.getInputStream();
                     RandomAccessFile raf = new RandomAccessFile(this.outputFilePath, "rw");){
                    int bytesRead;
                    raf.seek(this.startByte);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        raf.write(buffer, 0, bytesRead);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

