/*
 * Decompiled with CFR 0.152.
 */
package com.alazeprt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Dependency {
    private final String dependency;
    private final String centralUrl;

    public Dependency(String dependency) {
        this.dependency = dependency;
        this.centralUrl = "https://repo.maven.apache.org/maven2/";
    }

    public Dependency(String dependency, String centralUrl) {
        this.dependency = dependency;
        if (!((String)centralUrl).endsWith("/")) {
            centralUrl = (String)centralUrl + "/";
        }
        this.centralUrl = centralUrl;
    }

    public Dependency(String groupId, String artifactId, String version) {
        this.dependency = groupId + ":" + artifactId + ":" + version;
        this.centralUrl = "https://repo.maven.apache.org/maven2/";
    }

    public String getDependency() {
        return this.dependency;
    }

    public String parseDependency() {
        String[] strings = this.dependency.split(":");
        String packageUrl = strings[0].replace(".", "/");
        return this.centralUrl + packageUrl + "/" + strings[1] + "/" + strings[2];
    }

    private List<Dependency> getSubDependencies(List<Dependency> list) throws IOException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Dependency dependency : list) {
            Model model;
            if (dependency.getDependency().split(":")[1].equals("junit") || dependency.getDependency().split(":")[1].equals("junit-jupiter-api")) continue;
            URL pomUrl = new URL(dependency.parseDependency() + "/" + dependency.getDependency().split(":")[1] + "-" + dependency.getDependency().split(":")[2] + ".pom");
            HttpURLConnection connection = (HttpURLConnection)pomUrl.openConnection();
            InputStream in = connection.getInputStream();
            MavenXpp3Reader reader = new MavenXpp3Reader();
            try {
                model = reader.read(in);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            in.close();
            connection.disconnect();
            if (model.getDependencies().isEmpty()) {
                dependencies.add(dependency);
                continue;
            }
            ArrayList<Dependency> subDependencies = new ArrayList<Dependency>();
            for (org.apache.maven.model.Dependency mavenDependency : model.getDependencies()) {
                Dependency subDependency;
                if (mavenDependency.getArtifactId().equals("junit") || mavenDependency.getArtifactId().equals("junit-jupiter-api")) continue;
                ArrayList<Dependency> list1 = new ArrayList<Dependency>();
                list1.addAll(subDependencies);
                list1.addAll(dependencies);
                list1.addAll(list);
                if (mavenDependency.getVersion() == null || mavenDependency.getVersion().startsWith("${")) {
                    if (mavenDependency.getGroupId().startsWith("${")) {
                        version = this.getSameVersion(list1, mavenDependency.getArtifactId(), mavenDependency.getArtifactId());
                        subDependency = new Dependency(mavenDependency.getArtifactId(), mavenDependency.getArtifactId(), version);
                    } else {
                        version = this.getSameVersion(list1, mavenDependency.getGroupId(), mavenDependency.getArtifactId());
                        subDependency = new Dependency(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), version);
                    }
                } else if (mavenDependency.getGroupId().startsWith("${")) {
                    version = this.getSameVersion(list1, mavenDependency.getArtifactId(), mavenDependency.getArtifactId());
                    subDependency = new Dependency(mavenDependency.getArtifactId(), mavenDependency.getArtifactId(), version);
                } else {
                    version = this.getSameVersion(list1, mavenDependency.getGroupId(), mavenDependency.getArtifactId());
                    subDependency = new Dependency(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), version);
                }
                subDependencies.add(subDependency);
            }
            dependencies.addAll(subDependencies);
        }
        dependencies.addAll(list);
        return dependencies;
    }

    public List<Dependency> getSubDependencies() throws XmlPullParserException, IOException {
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        list.add(this);
        return this.getSubDependencies(list);
    }

    private String getSameVersion(List<Dependency> subDependencies, String groupId, String artifactId) throws IOException {
        String version = this.getLatestVersion(groupId, artifactId);
        for (Dependency dependency : subDependencies) {
            if (!dependency.getDependency().split(":")[0].equals(groupId) || !this.versionFound(groupId, artifactId, dependency.getDependency().split(":")[2])) continue;
            version = dependency.getDependency().split(":")[2];
            break;
        }
        return version;
    }

    private String getLatestVersion(String groupId, String artifactId) throws IOException {
        String mavenMetadataUrl = "https://repo.maven.apache.org/maven2/" + groupId.replace(".", "/") + "/" + artifactId + "/maven-metadata.xml";
        URL url = new URL(mavenMetadataUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        Pattern pattern = Pattern.compile("<latest>(.*?)</latest>");
        Matcher matcher = pattern.matcher(response.toString());
        if (matcher.find()) {
            return matcher.group(1);
        }
        Pattern pattern1 = Pattern.compile("<version>(.*?)</version>");
        Matcher matcher1 = pattern1.matcher(response.toString());
        if (matcher1.find()) {
            return matcher1.group(1);
        }
        return null;
    }

    private boolean versionFound(String groupId, String artifactId, String version) throws IOException {
        String mavenMetadataUrl = "https://repo.maven.apache.org/maven2/" + groupId.replace(".", "/") + "/" + artifactId + "/maven-metadata.xml";
        URL url = new URL(mavenMetadataUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        if (response.isEmpty()) {
            return false;
        }
        return response.toString().contains(version);
    }
}

