/*
 * Decompiled with CFR 0.152.
 */
package com.alazeprt;

import com.alazeprt.Dependency;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class DependencyDownloader {
    public static void downloadAll(List<Dependency> list, String outputFolder, int threads) throws IOException {
        File folder = new File((String)outputFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!((String)outputFolder).endsWith("/")) {
            outputFolder = (String)outputFolder + "/";
        }
        for (Dependency dependency : list) {
            if (new File((String)outputFolder + dependency.getDependency().split(":")[1] + "-" + dependency.getDependency().split(":")[2] + ".jar").exists()) continue;
            Object fileUrl = dependency.parseDependency();
            fileUrl = (String)fileUrl + "/" + dependency.getDependency().split(":")[1] + "-" + dependency.getDependency().split(":")[2] + ".jar";
            System.out.println("Downloading " + dependency.getDependency().split(":")[1] + "-" + dependency.getDependency().split(":")[2] + ".jar");
            DependencyDownloader.downloadFiles((String)fileUrl, (String)outputFolder + dependency.getDependency().split(":")[1] + "-" + dependency.getDependency().split(":")[2] + ".jar", threads);
        }
    }

    private static void downloadFiles(String fileUrl, String outputFilePath, int numThreads) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int fileSize = connection.getContentLength();
        connection.disconnect();
        int chunkSize = fileSize / numThreads;
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            int startByte = i * chunkSize;
            int endByte = i == numThreads - 1 ? fileSize - 1 : (i + 1) * chunkSize - 1;
            threads[i] = new Thread(new DownloadThread(fileUrl, startByte, endByte, outputFilePath));
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class DownloadThread
    implements Runnable {
        private final String fileUrl;
        private final int startByte;
        private final int endByte;
        private final String outputFilePath;

        private DownloadThread(String fileUrl, int startByte, int endByte, String outputFilePath) {
            this.fileUrl = fileUrl;
            this.startByte = startByte;
            this.endByte = endByte;
            this.outputFilePath = outputFilePath;
        }

        @Override
        public void run() {
            try {
                URL url = new URL(this.fileUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Range", "bytes=" + this.startByte + "-" + this.endByte);
                try (InputStream in = connection.getInputStream();
                     RandomAccessFile raf = new RandomAccessFile(this.outputFilePath, "rw");){
                    int bytesRead;
                    raf.seek(this.startByte);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        raf.write(buffer, 0, bytesRead);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

