/*
 * Decompiled with CFR 0.152.
 */
package com.alazeprt;

import com.alazeprt.Dependency;
import com.alazeprt.DependencyClass;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class DependencyLoader {
    private URLClassLoader classLoader;

    public DependencyLoader(String libPath, List<Dependency> list) throws MalformedURLException {
        if (!((String)libPath).endsWith("/") || !((String)libPath).endsWith("\\")) {
            libPath = (String)libPath + "\\";
        }
        URL[] urls = new URL[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            urls[i] = new File((String)libPath + list.get(i).getDependency().split(":")[1] + "-" + list.get(i).getDependency().split(":")[2] + ".jar").toURI().toURL();
        }
        this.classLoader = new URLClassLoader(urls);
    }

    public DependencyLoader(String libPath) throws MalformedURLException {
        this.classLoader = new URLClassLoader(new URL[]{new File(libPath).toURI().toURL()});
    }

    public DependencyClass construct(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return new DependencyClass(this.classLoader.loadClass(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    public void loadMoreLibrary(String libPath) throws MalformedURLException {
        URL[] currentUrls = this.classLoader.getURLs();
        URL[] newUrls = new URL[currentUrls.length + 1];
        System.arraycopy(currentUrls, 0, newUrls, 0, currentUrls.length);
        newUrls[currentUrls.length] = new File(libPath).toURI().toURL();
        this.classLoader = new URLClassLoader(newUrls);
    }

    public DependencyClass construct(String className, Object ... args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> targetClass = this.classLoader.loadClass(className);
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        Constructor<?> constructor = targetClass.getConstructor(parameterTypes);
        return new DependencyClass(constructor.newInstance(args));
    }

    public Class<?> getLocalClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public Object runStaticMethod(String className, String methodName, Object ... args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> targetClass = this.classLoader.loadClass(className);
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        Method method = DependencyLoader.getConfirmMethod(targetClass, methodName, args);
        if (method == null) {
            return null;
        }
        Object result = method.invoke(null, args);
        if (method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        return method.getReturnType().cast(result);
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    static Method getConfirmMethod(Class<?> targetClass, String methodName, Object ... args) {
        Method[] methods;
        for (Method method : methods = targetClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || args.length != method.getParameterCount()) continue;
            Class<?>[] classes = method.getParameterTypes();
            boolean isMethod = true;
            for (int i = 0; i < args.length; ++i) {
                if (classes[i].isInstance(args[i])) continue;
                isMethod = false;
                break;
            }
            if (!isMethod) continue;
            return method;
        }
        return null;
    }
}

