/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.innodb.java.reader.cli;

import com.alibaba.innodb.java.reader.TableReader;
import com.alibaba.innodb.java.reader.TableReaderFactory;
import com.alibaba.innodb.java.reader.cli.CommandType;
import com.alibaba.innodb.java.reader.cli.JsonMapper;
import com.alibaba.innodb.java.reader.cli.OutputIOMode;
import com.alibaba.innodb.java.reader.cli.writer.SysoutWriter;
import com.alibaba.innodb.java.reader.cli.writer.Writer;
import com.alibaba.innodb.java.reader.cli.writer.WriterFactory;
import com.alibaba.innodb.java.reader.column.ColumnFactory;
import com.alibaba.innodb.java.reader.comparator.ComparisonOperator;
import com.alibaba.innodb.java.reader.config.ReaderSystemProperty;
import com.alibaba.innodb.java.reader.exception.ReaderException;
import com.alibaba.innodb.java.reader.heatmap.GenFillingRateHeatmapUtil;
import com.alibaba.innodb.java.reader.heatmap.GenLsnHeatmapUtil;
import com.alibaba.innodb.java.reader.page.AbstractPage;
import com.alibaba.innodb.java.reader.page.PageType;
import com.alibaba.innodb.java.reader.page.fsphdr.FspHdrXes;
import com.alibaba.innodb.java.reader.page.index.GenericRecord;
import com.alibaba.innodb.java.reader.page.index.Index;
import com.alibaba.innodb.java.reader.page.inode.Inode;
import com.alibaba.innodb.java.reader.schema.Column;
import com.alibaba.innodb.java.reader.schema.KeyMeta;
import com.alibaba.innodb.java.reader.schema.TableDef;
import com.alibaba.innodb.java.reader.schema.provider.TableDefProvider;
import com.alibaba.innodb.java.reader.schema.provider.impl.SqlFileTableDefProvider;
import com.alibaba.innodb.java.reader.util.Pair;
import com.alibaba.innodb.java.reader.util.ThreadContext;
import com.alibaba.innodb.java.reader.util.Utils;
import com.google.common.base.Preconditions;
import freemarker.template.TemplateException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnodbReaderBootstrap {
    private static final Logger log = LoggerFactory.getLogger(InnodbReaderBootstrap.class);
    private static final String JAR_NAME = "innodb-java-reader-cli.jar";
    private static String ALL_COMMANDS = Arrays.stream(CommandType.values()).map(CommandType::getType).collect(Collectors.joining(","));
    private static String ALL_OUTPUT_IO_MODE = Arrays.stream(OutputIOMode.values()).map(OutputIOMode::getMode).collect(Collectors.joining(","));
    private static final JsonMapper JSON_MAPPER = JsonMapper.buildNormalMapper();
    private static boolean SHOW_HEADER = false;
    private static String FIELD_DELIMITER = "\t";
    private static String COMPOSITE_KEY_DELIMITER = (String)ReaderSystemProperty.COMPOSITE_KEY_DELIMITER.value();
    private static String RANGE_QUERY_KEY_DELIMITER = (String)ReaderSystemProperty.RANGE_QUERY_KEY_DELIMITER.value();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] arguments) {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("h", "help", false, "usage");
        options.addOption("i", "ibd-file-path", true, "mandatory. innodb file path with suffix of .ibd");
        options.addOption("c", "command", true, "mandatory. command to run, valid commands are: " + ALL_COMMANDS);
        options.addOption("s", "create-table-sql-file-path", true, "create table sql file path, the sql is DDL as SHOW CREATE TABLE <table_name>, the file can contain multiple SQLs, the table name should match the ibd file name, or else the tool is not able to identify the ibd file to read, you can generate the file by executing mysqldump -d -u<username> -p<password> -h <hostname> <dbname>` in command-line.");
        options.addOption("json", "json-style", false, "set to true if you would like to show page info in json format style");
        options.addOption("jsonpretty", "json-pretty-style", false, "set to true if you would like to show page info in json pretty format style");
        options.addOption("showheader", "show-header", false, "set to true if you want to show table header when dumping table");
        options.addOption("o", "output", true, "save result to file instead of console, the argument is the file path");
        options.addOption("iomode", "output-io-mode", true, "output io mode, valid mode are: " + ALL_OUTPUT_IO_MODE);
        options.addOption("delimiter", "delimiter", true, "field delimiter, default is tab");
        options.addOption("projection", "projection", true, "projection list with column names delimited by comma");
        options.addOption("desc", "desc", false, "if records sorted in descending order, works for query all and range query");
        options.addOption("skname", "skname", true, "secondary key name");
        options.addOption("skordinal", "skordinal", true, "secondary key ordinal in DDL");
        options.addOption("args", true, "arguments");
        String command = null;
        String ibdFilePath = null;
        String tableName = null;
        String args = null;
        List<String> projection = null;
        boolean jsonStyle = false;
        boolean jsonPrettyStyle = false;
        boolean desc = false;
        String skName = null;
        int skOrdinal = -1;
        SqlFileTableDefProvider tableDefProvider = null;
        Writer writer = new SysoutWriter();
        writer.open();
        try {
            CommandType commandType;
            CommandLine line = parser.parse(options, arguments);
            if (line.hasOption("help")) {
                InnodbReaderBootstrap.showHelp(options, 0);
            }
            if (line.hasOption("ibd-file-path")) {
                ibdFilePath = line.getOptionValue("ibd-file-path");
                Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)ibdFilePath), (Object)"ibd-file-path is empty");
                Preconditions.checkArgument((ibdFilePath.lastIndexOf(".") > 0 ? 1 : 0) != 0, (Object)"ibd-file-path is not ended with .");
                int slashIndex = ibdFilePath.lastIndexOf("/");
                tableName = slashIndex >= 0 ? ibdFilePath.substring(slashIndex + 1, ibdFilePath.lastIndexOf(".")) : ibdFilePath.substring(0, ibdFilePath.lastIndexOf("."));
            } else {
                log.error("please input ibd-file-path");
                InnodbReaderBootstrap.showHelp(options, 1);
            }
            if (line.hasOption("create-table-sql-file-path")) {
                String createTableSqlFilePath = line.getOptionValue("create-table-sql-file-path");
                Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)createTableSqlFilePath), (Object)"create-table-sql-file-path is empty");
                tableDefProvider = new SqlFileTableDefProvider(createTableSqlFilePath);
            } else {
                log.error("please input create-table-sql");
                InnodbReaderBootstrap.showHelp(options, 1);
            }
            if (line.hasOption("command")) {
                command = line.getOptionValue("command");
            } else {
                log.error("please input command to run, cmd=" + ALL_COMMANDS);
                InnodbReaderBootstrap.showHelp(options, 1);
            }
            if (line.hasOption("args")) {
                args = line.getOptionValue("args");
            }
            if (line.hasOption("output")) {
                String outputFilePath = line.getOptionValue("output");
                OutputIOMode outputIOMode = OutputIOMode.parse(line.getOptionValue("output-io-mode"));
                writer = WriterFactory.build(outputIOMode, outputFilePath);
                writer.open();
            }
            FIELD_DELIMITER = line.hasOption("delimiter") ? line.getOptionValue("delimiter") : "\t";
            if (line.hasOption("projection")) {
                String projectionStr = line.getOptionValue("projection");
                Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)projectionStr), (Object)"projection list is empty");
                projection = Arrays.asList(StringUtils.split((String)projectionStr, (String)","));
            }
            if (line.hasOption("desc")) {
                desc = true;
            }
            if (line.hasOption("json-style")) {
                jsonStyle = true;
            }
            if (line.hasOption("json-pretty-style")) {
                jsonPrettyStyle = true;
            }
            SHOW_HEADER = line.hasOption("show-header");
            if (line.hasOption("skname")) {
                skName = line.getOptionValue("skname");
            }
            if (line.hasOption("skordinal")) {
                skOrdinal = Integer.parseInt(line.getOptionValue("skordinal"));
            }
            if ((commandType = (CommandType)EnumUtils.getEnum(CommandType.class, (String)command.replace("-", "_").toUpperCase())) == null) {
                log.error("invalid command type, should be " + ALL_COMMANDS);
                InnodbReaderBootstrap.showHelp(options, 1);
            }
            Preconditions.checkNotNull((Object)((Object)commandType));
            switch (commandType) {
                case SHOW_ALL_PAGES: {
                    InnodbReaderBootstrap.showAllPages(ibdFilePath, writer, (TableDefProvider)tableDefProvider, tableName);
                    return;
                }
                case SHOW_PAGES: {
                    Preconditions.checkNotNull((Object)args, (Object)"args should not be null");
                    List<Long> pageNumbers = Stream.of(args.split(",")).map(Long::parseLong).collect(Collectors.toList());
                    InnodbReaderBootstrap.showPages(ibdFilePath, writer, (TableDefProvider)tableDefProvider, tableName, pageNumbers, jsonStyle, jsonPrettyStyle);
                    return;
                }
                case QUERY_ALL: {
                    InnodbReaderBootstrap.queryAll(ibdFilePath, writer, (TableDefProvider)tableDefProvider, tableName, projection, desc);
                    return;
                }
                case QUERY_BY_PAGE_NUMBER: {
                    Preconditions.checkNotNull((Object)args, (Object)"args should not be null");
                    long pageNumber = Long.parseLong(args);
                    InnodbReaderBootstrap.queryByPageNumber(ibdFilePath, writer, (TableDefProvider)tableDefProvider, tableName, pageNumber);
                    return;
                }
                case QUERY_BY_PK: {
                    Preconditions.checkNotNull((Object)args, (Object)"args should not be null");
                    InnodbReaderBootstrap.queryByPrimaryKey(ibdFilePath, writer, (TableDefProvider)tableDefProvider, tableName, projection, args);
                    return;
                }
                case QUERY_BY_SK: {
                    Preconditions.checkNotNull((Object)args, (Object)"args should not be null");
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)skName), (Object)"skname should not be empty");
                    try {
                        List range;
                        if (skOrdinal >= 0) {
                            ThreadContext.init();
                            ThreadContext.putSkOrdinal((int)skOrdinal);
                        }
                        Preconditions.checkArgument(((range = Stream.of(args.split(RANGE_QUERY_KEY_DELIMITER)).collect(Collectors.toList())).size() == 4 ? 1 : 0) != 0, (Object)("Argument number should not exactly 4, but " + range.size()));
                        String lower = "null".equalsIgnoreCase((String)range.get(1)) ? null : (String)range.get(1);
                        String upper = "null".equalsIgnoreCase((String)range.get(3)) ? null : (String)range.get(3);
                        ComparisonOperator lowerOperator = "nop".equalsIgnoreCase((String)range.get(0)) ? ComparisonOperator.NOP : ComparisonOperator.parse((String)((String)range.get(0)));
                        ComparisonOperator upperOperator = "nop".equalsIgnoreCase((String)range.get(2)) ? ComparisonOperator.NOP : ComparisonOperator.parse((String)((String)range.get(2)));
                        InnodbReaderBootstrap.queryBySecondaryKey(ibdFilePath, writer, (TableDefProvider)tableDefProvider, tableName, skName, projection, lower, lowerOperator, upper, upperOperator, desc);
                        return;
                    }
                    finally {
                        ThreadContext.clean();
                    }
                }
                case RANGE_QUERY_BY_PK: {
                    Preconditions.checkNotNull((Object)args, (Object)"args should not be null");
                    List range = Stream.of(args.split(RANGE_QUERY_KEY_DELIMITER)).collect(Collectors.toList());
                    Preconditions.checkArgument((range.size() == 4 ? 1 : 0) != 0, (Object)("Argument number should not exactly 4, but " + range.size()));
                    String lower = "null".equalsIgnoreCase((String)range.get(1)) ? null : (String)range.get(1);
                    String upper = "null".equalsIgnoreCase((String)range.get(3)) ? null : (String)range.get(3);
                    ComparisonOperator lowerOperator = "nop".equalsIgnoreCase((String)range.get(0)) ? ComparisonOperator.NOP : ComparisonOperator.parse((String)((String)range.get(0)));
                    ComparisonOperator upperOperator = "nop".equalsIgnoreCase((String)range.get(2)) ? ComparisonOperator.NOP : ComparisonOperator.parse((String)((String)range.get(2)));
                    InnodbReaderBootstrap.rangeQueryByPrimaryKey(ibdFilePath, writer, (TableDefProvider)tableDefProvider, tableName, projection, lower, lowerOperator, upper, upperOperator, desc);
                    return;
                }
                case GEN_LSN_HEATMAP: {
                    InnodbReaderBootstrap.genHeatmap(ibdFilePath, (TableDefProvider)tableDefProvider, tableName, args, commandType);
                    return;
                }
                case GEN_FILLING_RATE_HEATMAP: {
                    InnodbReaderBootstrap.genHeatmap(ibdFilePath, (TableDefProvider)tableDefProvider, tableName, args, commandType);
                    return;
                }
                case GET_ALL_INDEX_PAGE_FILLING_RATE: {
                    InnodbReaderBootstrap.getAllIndexPageFillingRate(ibdFilePath, writer, (TableDefProvider)tableDefProvider, tableName);
                    return;
                }
                default: {
                    log.error("invalid command type, cmd=" + ALL_COMMANDS);
                    InnodbReaderBootstrap.showHelp(options, 1);
                    return;
                }
            }
        }
        catch (ParseException e) {
            log.error("Parse error occurred: " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (IOException e) {
            log.error("IO error occurred: " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (Exception e) {
            log.error("Error occurred: " + e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            try {
                Utils.close((Closeable)writer);
            }
            catch (IOException e) {
                log.error("Close writer failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void queryAll(String ibdFilePath, Writer writer, TableDefProvider tableDefProvider, String tableName, List<String> projection, boolean desc) {
        try (TableReader reader = InnodbReaderBootstrap.createTableReader(ibdFilePath, tableDefProvider, tableName);){
            reader.open();
            InnodbReaderBootstrap.showHeaderIfSet(reader, writer);
            Iterator iterator = CollectionUtils.isEmpty(projection) ? reader.getQueryAllIterator(!desc) : reader.getQueryAllIterator(projection, !desc);
            StringBuilder b = new StringBuilder();
            while (iterator.hasNext()) {
                GenericRecord record = (GenericRecord)iterator.next();
                writer.write(Utils.arrayToString((Object[])record.getValues(), (StringBuilder)b, (String)FIELD_DELIMITER, (boolean)writer.ifNewLineAfterWrite()));
            }
        }
    }

    private static void queryByPageNumber(String ibdFilePath, Writer writer, TableDefProvider tableDefProvider, String tableName, long pageNumber) {
        try (TableReader reader = InnodbReaderBootstrap.createTableReader(ibdFilePath, tableDefProvider, tableName);){
            reader.open();
            InnodbReaderBootstrap.showHeaderIfSet(reader, writer);
            List recordList = reader.queryByPageNumber(pageNumber);
            StringBuilder b = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)recordList)) {
                for (GenericRecord record : recordList) {
                    writer.write(Utils.arrayToString((Object[])record.getValues(), (StringBuilder)b, (String)FIELD_DELIMITER, (boolean)writer.ifNewLineAfterWrite()));
                }
            }
        }
    }

    private static void queryByPrimaryKey(String ibdFilePath, Writer writer, TableDefProvider tableDefProvider, String tableName, List<String> projection, String primaryKey) {
        try (TableReader reader = InnodbReaderBootstrap.createTableReader(ibdFilePath, tableDefProvider, tableName);){
            reader.open();
            InnodbReaderBootstrap.showHeaderIfSet(reader, writer);
            GenericRecord record = CollectionUtils.isEmpty(projection) ? reader.queryByPrimaryKey(InnodbReaderBootstrap.parseStringToKey(reader.getTableDef().getPrimaryKeyColumns(), primaryKey)) : reader.queryByPrimaryKey(InnodbReaderBootstrap.parseStringToKey(reader.getTableDef().getPrimaryKeyColumns(), primaryKey), projection);
            StringBuilder b = new StringBuilder();
            if (record != null) {
                writer.write(Utils.arrayToString((Object[])record.getValues(), (StringBuilder)b, (String)FIELD_DELIMITER, (boolean)writer.ifNewLineAfterWrite()));
            }
        }
    }

    private static void queryBySecondaryKey(String ibdFilePath, Writer writer, TableDefProvider tableDefProvider, String tableName, String skName, List<String> projection, String lower, ComparisonOperator lowerOperator, String upper, ComparisonOperator upperOperator, boolean desc) {
        try (TableReader reader = InnodbReaderBootstrap.createTableReader(ibdFilePath, tableDefProvider, tableName);){
            reader.open();
            InnodbReaderBootstrap.showHeaderIfSet(reader, writer);
            if (!reader.getTableDef().getSecondaryKeyMetaMap().containsKey(skName)) {
                throw new ReaderException("Secondary key not exist " + skName);
            }
            Iterator iterator = CollectionUtils.isEmpty(projection) ? reader.getRecordIteratorBySk(skName, InnodbReaderBootstrap.parseStringToKey(((KeyMeta)reader.getTableDef().getSecondaryKeyMetaMap().get(skName)).getKeyColumns(), lower), lowerOperator, InnodbReaderBootstrap.parseStringToKey(((KeyMeta)reader.getTableDef().getSecondaryKeyMetaMap().get(skName)).getKeyColumns(), upper), upperOperator, !desc) : reader.getRecordIteratorBySk(skName, InnodbReaderBootstrap.parseStringToKey(((KeyMeta)reader.getTableDef().getSecondaryKeyMetaMap().get(skName)).getKeyColumns(), lower), lowerOperator, InnodbReaderBootstrap.parseStringToKey(((KeyMeta)reader.getTableDef().getSecondaryKeyMetaMap().get(skName)).getKeyColumns(), upper), upperOperator, projection, !desc);
            StringBuilder b = new StringBuilder();
            while (iterator.hasNext()) {
                GenericRecord record = (GenericRecord)iterator.next();
                writer.write(Utils.arrayToString((Object[])record.getValues(), (StringBuilder)b, (String)FIELD_DELIMITER, (boolean)writer.ifNewLineAfterWrite()));
            }
        }
    }

    private static void rangeQueryByPrimaryKey(String ibdFilePath, Writer writer, TableDefProvider tableDefProvider, String tableName, List<String> projection, String lower, ComparisonOperator lowerOperator, String upper, ComparisonOperator upperOperator, boolean desc) {
        try (TableReader reader = InnodbReaderBootstrap.createTableReader(ibdFilePath, tableDefProvider, tableName);){
            reader.open();
            InnodbReaderBootstrap.showHeaderIfSet(reader, writer);
            Iterator iterator = CollectionUtils.isEmpty(projection) ? reader.getRangeQueryIterator(InnodbReaderBootstrap.parseStringToKey(reader.getTableDef().getPrimaryKeyColumns(), lower), lowerOperator, InnodbReaderBootstrap.parseStringToKey(reader.getTableDef().getPrimaryKeyColumns(), upper), upperOperator, !desc) : reader.getRangeQueryIterator(InnodbReaderBootstrap.parseStringToKey(reader.getTableDef().getPrimaryKeyColumns(), lower), lowerOperator, InnodbReaderBootstrap.parseStringToKey(reader.getTableDef().getPrimaryKeyColumns(), upper), upperOperator, projection, !desc);
            StringBuilder b = new StringBuilder();
            while (iterator.hasNext()) {
                GenericRecord record = (GenericRecord)iterator.next();
                writer.write(Utils.arrayToString((Object[])record.getValues(), (StringBuilder)b, (String)FIELD_DELIMITER, (boolean)writer.ifNewLineAfterWrite()));
            }
        }
    }

    private static void showHelp(Options options, int exitCode) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("java -jar innodb-java-reader-cli.jar", options, true);
        System.exit(exitCode);
    }

    private static void genHeatmap(String ibdFilePath, TableDefProvider tableDefProvider, String tableName, String args, CommandType commandType) throws IOException, TemplateException {
        Preconditions.checkNotNull((Object)args, (Object)"args should not be null");
        String destHtmlPath = args;
        Optional<Pair<String, String>> widthAndHeight = Optional.empty();
        if (args.contains(" ")) {
            Preconditions.checkState((args.split(" ").length == 3 ? 1 : 0) != 0, (Object)"argument number should not three when you want to specify width and height");
            destHtmlPath = args.split(" ")[0];
            List wh = Stream.of(args.split(" ")).skip(1L).collect(Collectors.toList());
            widthAndHeight = Optional.of(new Pair(wh.get(0), wh.get(1)));
        }
        if (CommandType.GEN_LSN_HEATMAP.equals((Object)commandType)) {
            InnodbReaderBootstrap.genLsnHeatmap(ibdFilePath, tableDefProvider, tableName, destHtmlPath, widthAndHeight);
        } else if (CommandType.GEN_FILLING_RATE_HEATMAP.equals((Object)commandType)) {
            InnodbReaderBootstrap.genFillingRateHeatmap(ibdFilePath, tableDefProvider, tableName, destHtmlPath, widthAndHeight);
        }
    }

    private static void genLsnHeatmap(String ibdFilePath, TableDefProvider tableDefProvider, String tableName, String destHtmlPath, Optional<Pair<String, String>> widthAndHeight) throws IOException, TemplateException {
        TableReaderFactory tableReaderFactory = TableReaderFactory.builder().withProvider(tableDefProvider).withDataFilePath(ibdFilePath).build();
        if (!tableReaderFactory.existTableDef(tableName)) {
            throw new IllegalArgumentException("table name " + tableName + " not found in sql file");
        }
        GenLsnHeatmapUtil.dump((String)ibdFilePath, (String)destHtmlPath, (TableDef)tableReaderFactory.getTableDef(tableName), (int)64, widthAndHeight);
    }

    private static void genFillingRateHeatmap(String ibdFilePath, TableDefProvider tableDefProvider, String tableName, String destHtmlPath, Optional<Pair<String, String>> widthAndHeight) throws IOException, TemplateException {
        TableReaderFactory tableReaderFactory = TableReaderFactory.builder().withProvider(tableDefProvider).withDataFilePath(ibdFilePath).build();
        if (!tableReaderFactory.existTableDef(tableName)) {
            throw new IllegalArgumentException("table name " + tableName + " not found in sql file");
        }
        GenFillingRateHeatmapUtil.dump((String)ibdFilePath, (String)destHtmlPath, (TableDef)tableReaderFactory.getTableDef(tableName), (int)64, widthAndHeight);
    }

    private static void showAllPages(String ibdFilePath, Writer writer, TableDefProvider tableDefProvider, String tableName) {
        try (TableReader reader = InnodbReaderBootstrap.createTableReader(ibdFilePath, tableDefProvider, tableName);){
            reader.open();
            Iterator iterator = reader.getPageIterator();
            writer.write(StringUtils.repeat((String)"=", (int)5) + "page number, page type, other info" + StringUtils.repeat((String)"=", (int)5));
            while (iterator.hasNext()) {
                AbstractPage page = (AbstractPage)iterator.next();
                StringBuilder sb = new StringBuilder();
                sb.append(page.getPageNumber());
                sb.append(",");
                sb.append(page.pageType().name());
                if (PageType.FILE_SPACE_HEADER.equals((Object)page.pageType()) || PageType.EXTENT_DESCRIPTOR.equals((Object)page.pageType())) {
                    sb.append(",space=");
                    sb.append(((FspHdrXes)page).getFspHeader().getSpace());
                    sb.append(",numPagesUsed=");
                    sb.append(((FspHdrXes)page).getFspHeader().getNumberOfPagesUsed());
                    sb.append(",size=");
                    sb.append(((FspHdrXes)page).getFspHeader().getSize());
                    sb.append(",xdes.size=");
                    sb.append(((FspHdrXes)page).getXdesList().size());
                } else if (PageType.INODE.equals((Object)page.pageType())) {
                    sb.append(",inode.size=");
                    sb.append(((Inode)page).getInodeEntryList().size());
                } else if (PageType.INDEX.equals((Object)page.pageType())) {
                    if (((Index)page).isRootPage()) {
                        sb.append(",root.page=true");
                    }
                    sb.append(",index.id=");
                    sb.append(((Index)page).getIndexHeader().getIndexId());
                    sb.append(",level=");
                    sb.append(((Index)page).getIndexHeader().getPageLevel());
                    sb.append(",numOfRecs=");
                    sb.append(((Index)page).getIndexHeader().getNumOfRecs());
                    sb.append(",num.dir.slot=");
                    sb.append(((Index)page).getIndexHeader().getNumOfDirSlots());
                    sb.append(",garbage.space=");
                    sb.append(((Index)page).getIndexHeader().getGarbageSpace());
                }
                writer.write(sb.toString());
            }
        }
    }

    private static void showPages(String ibdFilePath, Writer writer, TableDefProvider tableDefProvider, String tableName, List<Long> pageNumberList, boolean jsonStyle, boolean jsonPrettyStyle) {
        try (TableReader reader = InnodbReaderBootstrap.createTableReader(ibdFilePath, tableDefProvider, tableName);){
            reader.open();
            for (Long pageNumber : pageNumberList) {
                AbstractPage page = reader.readPage(pageNumber.longValue());
                if (jsonStyle) {
                    writer.write(JSON_MAPPER.toJson(page));
                    continue;
                }
                if (jsonPrettyStyle) {
                    writer.write(JSON_MAPPER.toPrettyJson(page));
                    continue;
                }
                writer.write(page.toString());
            }
        }
    }

    private static void getAllIndexPageFillingRate(String ibdFilePath, Writer writer, TableDefProvider tableDefProvider, String tableName) {
        try (TableReader reader = InnodbReaderBootstrap.createTableReader(ibdFilePath, tableDefProvider, tableName);){
            reader.open();
            writer.write("Number of pages is " + reader.getNumOfPages());
            writer.write("Index page filling rate is " + reader.getAllIndexPageFillingRate());
        }
    }

    private static void showHeaderIfSet(TableReader reader, Writer writer) {
        if (SHOW_HEADER) {
            TableDef tableDef = reader.getTableDef();
            writer.write(tableDef.getColumnNames().stream().collect(Collectors.joining(FIELD_DELIMITER)));
            if (writer.ifNewLineAfterWrite()) {
                writer.write("\n");
            }
        }
    }

    private static List<Object> parseStringToKey(List<Column> keyColumns, String input) {
        int keyColNum = keyColumns.size();
        if (input == null) {
            return null;
        }
        String[] array = input.split(COMPOSITE_KEY_DELIMITER, -1);
        if (array.length != keyColNum) {
            throw new IllegalArgumentException("Key column number should be " + keyColNum + ", input is " + input + ", actual length is " + array.length);
        }
        ArrayList result = new ArrayList(keyColNum);
        for (int i = 0; i < keyColNum; ++i) {
            Column pk = keyColumns.get(i);
            if (array[i].length() == 0 || "null".equalsIgnoreCase(array[i])) continue;
            Object val = ColumnFactory.getColumnToJavaTypeFunc((String)pk.getType()).apply(array[i]);
            result.add(val);
        }
        return Collections.unmodifiableList(result);
    }

    private static TableReader createTableReader(String ibdFilePath, TableDefProvider tableDefProvider, String tableName) {
        TableReaderFactory tableReaderFactory = TableReaderFactory.builder().withProvider(tableDefProvider).withDataFilePath(ibdFilePath).build();
        return tableReaderFactory.createTableReader(tableName);
    }
}

