/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.innodb.java.reader.cli;

import com.google.common.collect.Maps;
import java.util.Map;

public enum OutputIOMode {
    BUFFER("buffer", "use Java NIO 2.0 buffer io which leverages page cache"),
    MMAP("mmap", "use mmap to write"),
    DIRECT("direct", "use direct io to writer");

    private String mode;
    private String desc;
    private static Map<String, OutputIOMode> KVS;

    private OutputIOMode(String mode, String desc) {
        this.mode = mode;
        this.desc = desc;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String type) {
        this.mode = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static OutputIOMode parse(String mode) {
        return KVS.get(mode);
    }

    static {
        KVS = Maps.newHashMapWithExpectedSize((int)OutputIOMode.values().length);
        for (OutputIOMode mode : OutputIOMode.values()) {
            KVS.put(mode.getMode(), mode);
        }
    }
}

