/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.innodb.java.reader.cli;

import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMapper {
    private static final Logger log = LoggerFactory.getLogger(JsonMapper.class);
    private ObjectMapper mapper = new ObjectMapper();

    public JsonMapper(JsonSerialize.Inclusion inclusion) {
        this.mapper.setSerializationInclusion(inclusion);
        this.mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
    }

    public static JsonMapper buildNormalMapper() {
        return new JsonMapper(JsonSerialize.Inclusion.ALWAYS);
    }

    public String toJson(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new IllegalStateException("Serialize object to json failed: " + object, e);
        }
    }

    public String toPrettyJson(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new IllegalStateException("Serialize object to json failed: " + object, e);
        }
    }
}

