/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.innodb.java.reader.cli.writer;

import com.alibaba.innodb.java.reader.cli.writer.Writer;
import com.alibaba.innodb.java.reader.cli.writer.WriterException;
import com.alibaba.innodb.java.reader.util.Utils;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import net.smacke.jaydio.DirectRandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(DirectWriter.class);
    private static final int BUFFER_SIZE = 0x100000;
    private String outputFilePath;
    private DirectRandomAccessFile fout;

    public DirectWriter(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    @Override
    public void open() {
        Preconditions.checkNotNull((Object)this.outputFilePath);
        try {
            this.fout = new DirectRandomAccessFile(new File(this.outputFilePath), "rw", 0x100000);
            log.debug("Use direct io to write file {}", (Object)this.outputFilePath);
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public void write(String text) throws WriterException {
        try {
            byte[] bytes = text.getBytes("UTF-8");
            this.fout.write(bytes);
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public void close() throws WriterException {
        try {
            Utils.close((Closeable)this.fout);
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public boolean ifNewLineAfterWrite() {
        return true;
    }
}

