/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.innodb.java.reader.cli;

import com.alibaba.innodb.java.reader.cli.QuoteMode;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;

public class CsvPrinter {
    private String delimiter;
    private QuoteMode quoteMode;
    private String nullStr;
    private CSVFormat valueFormat;
    private StringBuilder row = new StringBuilder();
    private static final Map<QuoteMode, org.apache.commons.csv.QuoteMode> QUOTE_MODES = Maps.newHashMapWithExpectedSize((int)QuoteMode.values().length);

    public CsvPrinter(String delimiter, QuoteMode quoteMode, String nullStr) {
        this.delimiter = delimiter;
        this.quoteMode = quoteMode;
        this.nullStr = nullStr;
        this.valueFormat = CSVFormat.newFormat((char)',').withNullString(nullStr).withQuote('\"');
        if (quoteMode != QuoteMode.NONE) {
            this.valueFormat = this.valueFormat.withQuoteMode(QUOTE_MODES.get((Object)quoteMode));
        }
    }

    public String arrayToString(Object[] a, boolean newLine) {
        if (a == null) {
            return "null";
        }
        this.row.setLength(0);
        for (Object value : a) {
            if (this.quoteMode != QuoteMode.NONE) {
                try {
                    this.valueFormat.print(value, (Appendable)this.row, true);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            } else if (value == null) {
                this.row.append(this.nullStr);
            } else {
                this.row.append(value);
            }
            this.row.append(this.delimiter);
        }
        if (this.row.length() > 0) {
            this.row.deleteCharAt(this.row.length() - 1);
        }
        if (newLine) {
            this.row.append("\n");
        }
        return this.row.toString();
    }

    static {
        QUOTE_MODES.put(QuoteMode.ALL, org.apache.commons.csv.QuoteMode.ALL);
        QUOTE_MODES.put(QuoteMode.NON_NULL, org.apache.commons.csv.QuoteMode.ALL_NON_NULL);
        QUOTE_MODES.put(QuoteMode.NON_NUMERIC, org.apache.commons.csv.QuoteMode.NON_NUMERIC);
    }
}

