/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.innodb.java.reader.cli;

import com.google.common.collect.Maps;
import java.util.Map;

public enum QuoteMode {
    ALL("all", "quote all fields"),
    NON_NULL("nonnull", "quote all non-null fields"),
    NON_NUMERIC("nonnumeric", "quote all non-numeric fields"),
    NONE("none", "never quote fields");

    private String mode;
    private String desc;
    private static Map<String, QuoteMode> KVS;

    private QuoteMode(String mode, String desc) {
        this.mode = mode;
        this.desc = desc;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String type) {
        this.mode = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static QuoteMode parse(String mode) {
        return KVS.get(mode);
    }

    static {
        KVS = Maps.newHashMapWithExpectedSize((int)QuoteMode.values().length);
        for (QuoteMode mode : QuoteMode.values()) {
            KVS.put(mode.getMode(), mode);
        }
    }
}

