/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.innodb.java.reader.cli.writer;

import com.alibaba.innodb.java.reader.cli.writer.Writer;
import com.alibaba.innodb.java.reader.cli.writer.WriterException;
import com.alibaba.innodb.java.reader.util.Utils;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(BufferWriter.class);
    private final String outputFilePath;
    private FileChannel fileChannel;

    public BufferWriter(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    @Override
    public void open() {
        Preconditions.checkNotNull((Object)this.outputFilePath);
        try {
            this.fileChannel = new FileOutputStream(new File(this.outputFilePath), false).getChannel();
            log.debug("Use buffer io to write file {}", (Object)this.outputFilePath);
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public void write(String text) throws WriterException {
        try {
            this.fileChannel.write(ByteBuffer.wrap(text.getBytes("UTF-8")));
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public void close() throws WriterException {
        try {
            Utils.close((Closeable)this.fileChannel);
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public boolean ifNewLineAfterWrite() {
        return true;
    }
}

