/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.innodb.java.reader.cli.writer;

import com.alibaba.innodb.java.reader.cli.writer.MMapUtil;
import com.alibaba.innodb.java.reader.cli.writer.Writer;
import com.alibaba.innodb.java.reader.cli.writer.WriterException;
import com.alibaba.innodb.java.reader.util.Utils;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MmapWriter
implements Writer {
    private static final int MAPPED_BUFFER_SIZE = 0x1000000;
    private String outputFilePath;
    private FileChannel fileChannel;
    private MappedByteBuffer mappedByteBuffer;
    private long fileOffset;

    public MmapWriter(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    @Override
    public void open() {
        Preconditions.checkNotNull((Object)this.outputFilePath);
        try {
            this.fileChannel = new RandomAccessFile(new File(this.outputFilePath), "rw").getChannel();
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x1000000L);
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public void write(String text) throws WriterException {
        try {
            byte[] bytes = text.getBytes("UTF-8");
            this.ensureCapacity(bytes.length);
            this.mappedByteBuffer.put(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public void close() throws WriterException {
        try {
            this.fileOffset += (long)this.mappedByteBuffer.position();
            MMapUtil.unmap(this.mappedByteBuffer);
            if (this.fileChannel.isOpen()) {
                this.fileChannel.truncate(this.fileOffset);
            }
            Utils.close((Closeable)this.fileChannel);
        }
        catch (IOException e) {
            throw new WriterException(e);
        }
    }

    @Override
    public boolean ifNewLineAfterWrite() {
        return true;
    }

    private void ensureCapacity(int bytes) throws IOException {
        if (this.mappedByteBuffer.remaining() < bytes) {
            this.fileOffset += (long)this.mappedByteBuffer.position();
            MMapUtil.unmap(this.mappedByteBuffer);
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, this.fileOffset, 0x1000000L);
        }
    }
}

