/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.net;

import com.antgroup.antchain.myjava.classlib.java.net.TURL;
import com.antgroup.antchain.myjava.classlib.java.net.TUnknownServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TURLConnection {
    protected TURL url;
    private static boolean defaultAllowUserInteraction;
    private static boolean defaultUseCaches;
    private long lastModified = -1L;
    protected long ifModifiedSince;
    protected boolean useCaches = defaultUseCaches;
    protected boolean connected;
    protected boolean doOutput;
    protected boolean doInput = true;
    protected boolean allowUserInteraction = defaultAllowUserInteraction;
    private int readTimeout;
    private int connectTimeout;
    private Map<String, List<String>> requestProperties = new HashMap<String, List<String>>();

    protected TURLConnection(TURL url) {
        this.url = url;
    }

    public abstract void connect() throws IOException;

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public String getContentEncoding() {
        return this.getHeaderField("Content-Encoding");
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("Content-Length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public long getDate() {
        return this.getHeaderFieldDate("Date", 0L);
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    @Deprecated
    public static String getDefaultRequestProperty(String field) {
        return null;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("Expires", 0L);
    }

    public String getHeaderField(int pos) {
        return null;
    }

    public Map<String, List<String>> getHeaderFields() {
        return Collections.emptyMap();
    }

    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String key : this.requestProperties.keySet()) {
            map.put(key, Collections.unmodifiableList(this.requestProperties.get(key)));
        }
        return Collections.unmodifiableMap(map);
    }

    public void addRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        if (field == null) {
            throw new NullPointerException();
        }
        List<String> valuesList = this.requestProperties.get(field);
        if (valuesList == null) {
            valuesList = new ArrayList<String>();
            valuesList.add(0, newValue);
            this.requestProperties.put(field, valuesList);
        } else {
            valuesList.add(0, newValue);
        }
    }

    public String getHeaderField(String key) {
        return null;
    }

    public long getHeaderFieldDate(String field, long defaultValue) {
        String date = this.getHeaderField(field);
        if (date == null) {
            return defaultValue;
        }
        try {
            return Date.parse(date);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getHeaderFieldInt(String field, int defaultValue) {
        try {
            return Integer.parseInt(this.getHeaderField(field));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getHeaderFieldKey(int posn) {
        return null;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public InputStream getInputStream() throws IOException {
        throw new TUnknownServiceException();
    }

    public long getLastModified() {
        if (this.lastModified == -1L) {
            this.lastModified = this.getHeaderFieldDate("Last-Modified", 0L);
        }
        return this.lastModified;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new TUnknownServiceException();
    }

    public String getRequestProperty(String field) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        List<String> valuesList = this.requestProperties.get(field);
        if (valuesList == null) {
            return null;
        }
        return valuesList.get(0);
    }

    public TURL getURL() {
        return this.url;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    private String parseTypeString(String typeString) {
        StringBuilder typeStringBuffer = new StringBuilder(typeString);
        for (int i = 0; i < typeStringBuffer.length(); ++i) {
            char c = typeStringBuffer.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '.') continue;
            typeStringBuffer.setCharAt(i, '_');
        }
        return typeStringBuffer.toString();
    }

    public void setAllowUserInteraction(boolean newValue) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        this.allowUserInteraction = newValue;
    }

    public static void setDefaultAllowUserInteraction(boolean allows) {
        defaultAllowUserInteraction = allows;
    }

    @Deprecated
    public static void setDefaultRequestProperty(String field, String value) {
    }

    public void setDefaultUseCaches(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError();
        }
        defaultUseCaches = newValue;
    }

    public void setDoInput(boolean newValue) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        this.doInput = newValue;
    }

    public void setDoOutput(boolean newValue) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        this.doOutput = newValue;
    }

    public void setIfModifiedSince(long newValue) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        this.ifModifiedSince = newValue;
    }

    public void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        if (field == null) {
            throw new NullPointerException();
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        valuesList.add(newValue);
        this.requestProperties.put(field, valuesList);
    }

    public void setUseCaches(boolean newValue) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        this.useCaches = newValue;
    }

    public void setConnectTimeout(int timeout) {
        if (0 > timeout) {
            throw new IllegalArgumentException();
        }
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (0 > timeout) {
            throw new IllegalArgumentException();
        }
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.url.toString();
    }

    static {
        defaultUseCaches = true;
    }
}

