/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.nio.TByteBufferImpl;
import com.antgroup.antchain.myjava.classlib.java.nio.TByteOrder;
import com.antgroup.antchain.myjava.classlib.java.nio.TFloatBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TFloatBufferOverByteBuffer;

class TFloatBufferOverByteBufferBigEndian
extends TFloatBufferOverByteBuffer {
    public TFloatBufferOverByteBufferBigEndian(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(start, capacity, byteBuffer, position, limit, readOnly);
    }

    @Override
    TFloatBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TFloatBufferOverByteBufferBigEndian(this.start + start * 4, capacity, this.byteByffer, position, limit, readOnly);
    }

    @Override
    float getElement(int index) {
        int value = this.byteByffer.array[this.start + index * 4] & 0xFF | (this.byteByffer.array[this.start + index * 4 + 1] & 0xFF) << 8 | (this.byteByffer.array[this.start + index * 4 + 2] & 0xFF) << 16 | (this.byteByffer.array[this.start + index * 4 + 3] & 0xFF) << 24;
        return Float.intBitsToFloat(value);
    }

    @Override
    void putElement(int index, float f) {
        int value = Float.floatToIntBits(f);
        this.byteByffer.array[this.start + index * 4] = (byte)value;
        this.byteByffer.array[this.start + index * 4 + 1] = (byte)(value >> 8);
        this.byteByffer.array[this.start + index * 4 + 2] = (byte)(value >> 16);
        this.byteByffer.array[this.start + index * 4 + 3] = (byte)(value >> 24);
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.BIG_ENDIAN;
    }
}

