/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.logging;

import com.antgroup.antchain.myjava.classlib.PlatformDetector;
import com.antgroup.antchain.myjava.classlib.java.lang.TInteger;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.lang.TThrowable;
import com.antgroup.antchain.myjava.classlib.java.util.THashMap;
import com.antgroup.antchain.myjava.classlib.java.util.TMap;
import com.antgroup.antchain.myjava.classlib.java.util.logging.TLevel;
import com.antgroup.antchain.myjava.classlib.java.util.logging.TLogRecord;

public class TLogger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    private static TMap<String, TLogger> loggerCache = new THashMap<String, TLogger>();
    private String name;
    private TLogger parent;

    TLogger(String name) {
        this.name = name;
    }

    public static TLogger getGlobal() {
        return TLogger.getLogger(GLOBAL_LOGGER_NAME);
    }

    public static TLogger getLogger(String name) {
        TLogger logger = loggerCache.get(name);
        if (logger == null) {
            logger = new TLogger(name);
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex >= 0) {
                String parentName = name.substring(0, dotIndex);
                logger.parent = TLogger.getLogger(parentName);
            } else if (!name.isEmpty()) {
                logger.parent = TLogger.getLogger("");
            }
            loggerCache.put(name, logger);
        }
        return logger;
    }

    public static TLogger getAnonymousLogger() {
        return new TLogger(null);
    }

    public void log(TLogRecord record) {
        String message = this.format(record.getMessage(), record.getParameters());
        if (PlatformDetector.isLowLevel()) {
            System.out.print("[");
            System.out.print(record.getLevel().getName());
            System.out.print("] ");
            System.out.println(message);
            if (record.getThrown() != null) {
                record.getThrown().printStackTrace(System.out);
            }
        } else if (record.getLevel().intValue() >= TLevel.SEVERE.intValue()) {
            TLogger.error(message);
        } else if (record.getLevel().intValue() >= TLevel.WARNING.intValue()) {
            TLogger.warn(message);
        } else {
            TLogger.infoImpl(message);
        }
    }

    private String format(String message, Object[] params) {
        int paramStart;
        int next;
        if (params == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < message.length() && (next = message.indexOf(123, index)) >= 0 && (next = TLogger.digits(paramStart = next + 1, message)) >= 0) {
            if (message.charAt(next) != '}') {
                sb.append(message, index, next);
                index = next;
                continue;
            }
            int paramIndex = TInteger.parseInt(message.substring(paramStart, next));
            if (paramIndex >= params.length) {
                sb.append(message, index, next);
                index = next;
                continue;
            }
            sb.append(params[paramIndex]);
            index = next + 1;
        }
        return sb.toString();
    }

    private static int digits(int from, String message) {
        while (from < message.length()) {
            char c;
            if ((c = message.charAt(from++)) > '0' && c < '9') continue;
            return from;
        }
        return -1;
    }

    public void log(TLevel level, String msg, Object[] params) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setParameters(params);
        this.log(record);
    }

    public void log(TLevel level, String msg) {
        this.log(new TLogRecord(level, msg));
    }

    public void log(TLevel level, String msg, TObject param1) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setParameters(new Object[]{param1});
        this.log(record);
    }

    public void log(TLevel level, String msg, TThrowable thrown) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setThrown(thrown);
        this.log(record);
    }

    public void severe(String msg) {
        this.log(TLevel.SEVERE, msg);
    }

    public void warning(String msg) {
        this.log(TLevel.WARNING, msg);
    }

    public void info(String msg) {
        this.log(TLevel.INFO, msg);
    }

    public void config(String msg) {
        this.log(TLevel.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(TLevel.FINE, msg);
    }

    public void finer(String msg) {
        this.log(TLevel.FINER, msg);
    }

    public void finest(String msg) {
        this.log(TLevel.FINEST, msg);
    }

    public boolean isLoggable(TLevel level) {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public TLogger getParent() {
        return this.parent;
    }

    public void setParent(TLogger parent) {
        this.parent = parent;
    }

    private static void infoImpl(String message) {
    }

    private static void warn(String message) {
    }

    private static void error(String message) {
    }
}

