/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.regex;

import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.THighSurrogateCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TJointSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TMatchResultImpl;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplRangeSet;

class TLowSurrogateCharSet
extends TJointSet {
    private char low;

    public TLowSurrogateCharSet(char low) {
        this.low = low;
    }

    @Override
    public TAbstractSet getNext() {
        return this.next;
    }

    @Override
    public void setNext(TAbstractSet next) {
        this.next = next;
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        char high;
        if (stringIndex + 1 > matchResult.getRightBound()) {
            matchResult.hitEnd = true;
            return -1;
        }
        char low = testString.charAt(stringIndex);
        if (stringIndex > matchResult.getLeftBound() && Character.isHighSurrogate(high = testString.charAt(stringIndex - 1))) {
            return -1;
        }
        if (this.low == low) {
            return this.next.matches(stringIndex + 1, testString, matchResult);
        }
        return -1;
    }

    @Override
    public int find(int strIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (testString instanceof String) {
            String testStr = (String)testString;
            int startStr = matchResult.getLeftBound();
            int strLength = matchResult.getRightBound();
            while (strIndex < strLength) {
                if ((strIndex = testStr.indexOf(this.low, strIndex)) < 0) {
                    return -1;
                }
                if (strIndex > startStr && Character.isHighSurrogate(testStr.charAt(strIndex - 1))) {
                    ++strIndex;
                    continue;
                }
                if (this.next.matches(strIndex + 1, testString, matchResult) >= 0) {
                    return strIndex;
                }
                ++strIndex;
            }
            return -1;
        }
        return super.find(strIndex, testString, matchResult);
    }

    @Override
    public int findBack(int strIndex, int lastIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (testString instanceof String) {
            int startStr = matchResult.getLeftBound();
            String testStr = (String)testString;
            while (lastIndex >= strIndex) {
                if ((lastIndex = testStr.lastIndexOf(this.low, lastIndex)) < 0 || lastIndex < strIndex) {
                    return -1;
                }
                if (lastIndex > startStr && Character.isHighSurrogate(testStr.charAt(lastIndex - 1))) {
                    lastIndex -= 2;
                    continue;
                }
                if (this.next.matches(lastIndex + 1, testString, matchResult) >= 0) {
                    return lastIndex;
                }
                --lastIndex;
            }
            return -1;
        }
        return super.findBack(strIndex, lastIndex, testString, matchResult);
    }

    @Override
    protected String getName() {
        return "" + this.low;
    }

    protected int getChar() {
        return this.low;
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (set instanceof TCharSet) {
            return false;
        }
        if (set instanceof TRangeSet) {
            return false;
        }
        if (set instanceof TSupplRangeSet) {
            return false;
        }
        if (set instanceof TSupplCharSet) {
            return false;
        }
        if (set instanceof THighSurrogateCharSet) {
            return false;
        }
        if (set instanceof TLowSurrogateCharSet) {
            return ((TLowSurrogateCharSet)set).low == this.low;
        }
        return true;
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl matchResult) {
        return true;
    }
}

