/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.classlib.impl.IntegerUtil;
import com.antgroup.antchain.myjava.classlib.java.lang.TCharacter;
import com.antgroup.antchain.myjava.classlib.java.lang.TComparable;
import com.antgroup.antchain.myjava.classlib.java.lang.TNumber;
import com.antgroup.antchain.myjava.classlib.java.lang.TNumberFormatException;
import com.antgroup.antchain.myjava.classlib.java.lang.TString;
import com.antgroup.antchain.myjava.classlib.java.lang.TStringBuilder;
import com.antgroup.antchain.myjava.classlib.java.lang.TSystem;
import com.antgroup.antchain.myjava.interop.NoInitClass;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.NoSideEffects;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

@NoMetadata
public class TLong
extends TNumber
implements TComparable<TLong> {
    public static final long MIN_VALUE = Long.MIN_VALUE;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final Class<Long> TYPE = Long.TYPE;
    public static final int SIZE = 64;
    private long value;

    private static void cpdBegin() {
    }

    public TLong(long value) {
        this.value = value;
    }

    public TLong(String value) throws TNumberFormatException {
        this(TLong.parseLong(value));
    }

    public static TLong valueOf(long value) {
        return new TLong(value);
    }

    public static long parseLong(String s, int radix) throws TNumberFormatException {
        if (radix < 2 || radix > 36) {
            throw new TNumberFormatException("Illegal radix: " + radix);
        }
        if (s == null || s.isEmpty()) {
            throw new TNumberFormatException("String is null or empty");
        }
        boolean negative = false;
        int index = 0;
        switch (s.charAt(0)) {
            case '-': {
                negative = true;
                index = 1;
                break;
            }
            case '+': {
                index = 1;
                break;
            }
        }
        long value = 0L;
        while (index < s.length()) {
            int digit;
            if ((digit = TCharacter.getNumericValue(s.charAt(index++))) < 0) {
                throw new TNumberFormatException("String contains invalid digits: " + s);
            }
            if (digit >= radix) {
                throw new TNumberFormatException("String contains digits out of radix " + radix + ": " + s);
            }
            if ((value = (long)radix * value + (long)digit) >= 0L) continue;
            if (index == s.length() && value == Long.MIN_VALUE && negative) {
                return Long.MIN_VALUE;
            }
            throw new TNumberFormatException("The value is too big for int type: " + s);
        }
        return negative ? -value : value;
    }

    public static long parseLong(String s) throws TNumberFormatException {
        return TLong.parseLong(s, 10);
    }

    public static TLong valueOf(String s, int radix) throws TNumberFormatException {
        return TLong.valueOf(TLong.parseLong(s, radix));
    }

    public static TLong valueOf(String s) throws TNumberFormatException {
        return TLong.valueOf(TLong.parseLong(s));
    }

    public static TLong decode(TString nm) throws TNumberFormatException {
        if (nm == null || nm.isEmpty()) {
            throw new TNumberFormatException("Can't parse empty or null string");
        }
        int index = 0;
        boolean negaive = false;
        if (nm.charAt(index) == '+') {
            ++index;
        } else if (nm.charAt(index) == '-') {
            ++index;
            negaive = true;
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException("The string does not represent a number");
        }
        int radix = 10;
        if (nm.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (nm.charAt(index) == '0') {
            if (++index == nm.length()) {
                return TLong.valueOf(0L);
            }
            if (nm.charAt(index) == 'x' || nm.charAt(index) == 'X') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException("The string does not represent a number");
        }
        long value = 0L;
        while (index < nm.length()) {
            int digit;
            if ((digit = TLong.decodeDigit(nm.charAt(index++))) >= radix) {
                throw new TNumberFormatException("The string does not represent a number");
            }
            if ((value = value * (long)radix + (long)digit) >= 0L) continue;
            if (negaive && value == Long.MIN_VALUE && index == nm.length()) {
                return TLong.valueOf(Long.MIN_VALUE);
            }
            throw new TNumberFormatException("The string represents a too big number");
        }
        return TLong.valueOf(negaive ? -value : value);
    }

    private static int decodeDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        return 255;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static String toString(long i, int radix) {
        return new TStringBuilder().insert(0, i, radix).toString();
    }

    public static String toHexString(long i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 4);
    }

    public static String toOctalString(long i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 3);
    }

    public static String toBinaryString(long i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 1);
    }

    public static String toString(long value) {
        return new TStringBuilder().append(value).toString();
    }

    @Override
    public String toString() {
        return TLong.toString(this.value);
    }

    @Override
    public int hashCode() {
        return TLong.hashCode(this.value);
    }

    private static int hashCode(long value) {
        return (int)value ^ (int)(value >>> 32);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TLong && ((TLong)other).value == this.value;
    }

    @NoSideEffects
    public static native int compare(long var0, long var2);

    @Override
    public int compareTo(TLong other) {
        return TLong.compare(this.value, other.value);
    }

    public static TLong getLong(String nm) {
        return TLong.getLong(nm, null);
    }

    public static TLong getLong(String nm, long val) {
        return TLong.getLong(nm, TLong.valueOf(val));
    }

    public static TLong getLong(String nm, TLong val) {
        String result = nm != null ? TSystem.getProperty(nm) : null;
        try {
            return result != null ? TLong.valueOf(result) : val;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long highestOneBit(long i) {
        return Long.MIN_VALUE >>> TLong.numberOfLeadingZeros(i);
    }

    @NoSideEffects
    @Unmanaged
    @NoInitClass
    public static int numberOfLeadingZeros(long i) {
        return (int)WasmRuntime.numberOfLeadingZerosOfInt64((long)i);
    }

    @NoSideEffects
    @Unmanaged
    @NoInitClass
    public static int numberOfTrailingZeros(long i) {
        return (int)WasmRuntime.numberOfTrailingZerosOfInt64((long)i);
    }

    public static long lowestOneBit(long i) {
        return 1L << TLong.numberOfTrailingZeros(i);
    }

    @NoSideEffects
    @Unmanaged
    @NoInitClass
    public static int bitCount(long i) {
        return (int)WasmRuntime.bitCountOfInt64((long)i);
    }

    @NoSideEffects
    @Unmanaged
    @NoInitClass
    public static long rotateLeft(long i, int distance) {
        return WasmRuntime.rotateLeftOfInt64((long)i, (long)distance);
    }

    @NoSideEffects
    @Unmanaged
    @NoInitClass
    public static long rotateRight(long i, int distance) {
        return WasmRuntime.rotateRightOfInt64((long)i, (long)distance);
    }

    public static long reverse(long i) {
        i = (i & 0xAAAAAAAAAAAAAAAAL) >>> 1 | (i & 0x5555555555555555L) << 1;
        i = (i & 0xCCCCCCCCCCCCCCCCL) >>> 2 | (i & 0x3333333333333333L) << 2;
        i = (i & 0xF0F0F0F0F0F0F0F0L) >>> 4 | (i & 0xF0F0F0F0F0F0F0FL) << 4;
        i = (i & 0xFF00FF00FF00FF00L) >>> 8 | (i & 0xFF00FF00FF00FFL) << 8;
        i = (i & 0xFFFF0000FFFF0000L) >>> 16 | (i & 0xFFFF0000FFFFL) << 16;
        i = (i & 0xFFFFFFFF00000000L) >>> 32 | (i & 0xFFFFFFFFL) << 32;
        return i;
    }

    public static long reverseBytes(long i) {
        i = (i & 0xFF00FF00FF00FF00L) >> 8 | (i & 0xFF00FF00FF00FFL) << 8;
        i = (i & 0xFFFF0000FFFF0000L) >> 16 | (i & 0xFFFF0000FFFFL) << 16;
        i = i >> 32 | i << 32;
        return i;
    }

    public static int signum(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor == 0L) {
            throw new RuntimeException("divide by zero exception");
        }
        return dividend / divisor;
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (divisor == 0L) {
            throw new RuntimeException("divide by zero exception");
        }
        return dividend % divisor;
    }

    private static void cpdEnd() {
    }
}

