/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.io.TIOException;
import com.antgroup.antchain.myjava.classlib.java.lang.TReadable;
import com.antgroup.antchain.myjava.classlib.java.nio.TBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TBufferOverflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TBufferUnderflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TByteOrder;
import com.antgroup.antchain.myjava.classlib.java.nio.TCharBufferOverArray;
import com.antgroup.antchain.myjava.classlib.java.nio.TReadOnlyBufferException;

public abstract class TCharBuffer
extends TBuffer
implements Comparable<TCharBuffer>,
Appendable,
CharSequence,
TReadable {
    TCharBuffer(int capacity, int position, int limit) {
        super(capacity);
        this.position = position;
        this.limit = limit;
    }

    abstract char getChar(int var1);

    abstract void putChar(int var1, char var2);

    public static TCharBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        return new TCharBufferOverArray(capacity);
    }

    public static TCharBuffer wrap(char[] array, int offset, int length) {
        return new TCharBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TCharBuffer wrap(char[] array) {
        return TCharBuffer.wrap(array, 0, array.length);
    }

    @Override
    public int read(TCharBuffer target) throws TIOException {
        if (target == null) {
            throw new NullPointerException("Target is null");
        }
        if (target.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (!this.hasRemaining()) {
            return -1;
        }
        int sz = Math.min(this.remaining(), target.remaining());
        int srcPos = this.position;
        int dstPos = target.position;
        for (int i = 0; i < sz; ++i) {
            target.putChar(dstPos++, this.getChar(srcPos++));
        }
        target.position += sz;
        return sz;
    }

    public static TCharBuffer wrap(CharSequence csq, int start, int end) {
        return TCharBuffer.wrap(csq.toString().toCharArray(), start, end - start);
    }

    public static TCharBuffer wrap(CharSequence csq) {
        return TCharBuffer.wrap(csq.toString().toCharArray());
    }

    public abstract TCharBuffer slice();

    public abstract TCharBuffer duplicate();

    public abstract TCharBuffer asReadOnlyBuffer();

    public abstract char get();

    public abstract TCharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract TCharBuffer put(int var1, char var2);

    public TCharBuffer get(char[] dst, int offset, int length) {
        if (offset < 0 || offset >= dst.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + dst.length + ")");
        }
        if (offset + length > dst.length) {
            throw new IndexOutOfBoundsException("The last char in dst " + (offset + length) + " is outside of array of size " + dst.length);
        }
        if (this.remaining() < length) {
            throw new TBufferUnderflowException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            dst[offset++] = this.getChar(pos++);
        }
        this.position += length;
        return this;
    }

    public TCharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TCharBuffer put(TCharBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < src.remaining()) {
            throw new TBufferOverflowException();
        }
        int length = src.remaining();
        int pos = this.position;
        int offset = src.position;
        for (int i = 0; i < length; ++i) {
            this.putChar(pos++, src.getChar(offset++));
        }
        this.position += length;
        return this;
    }

    public TCharBuffer put(char[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (offset < 0 || offset >= src.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + src.length + ")");
        }
        if (offset + length > src.length) {
            throw new IndexOutOfBoundsException("The last char in src " + (offset + length) + " is outside of array of size " + src.length);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            this.putChar(pos++, src[offset++]);
        }
        this.position += length;
        return this;
    }

    public final TCharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public TCharBuffer put(String src, int start, int end) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        int sz = end - start;
        if (this.remaining() < sz) {
            throw new TBufferOverflowException();
        }
        if (start < 0 || start >= src.length()) {
            throw new IndexOutOfBoundsException("Start " + start + " is outside of range [0;" + src.length() + ")");
        }
        if (end > src.length()) {
            throw new IndexOutOfBoundsException("The last char in src " + end + " is outside of string of size " + src.length());
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("Start " + start + " must be before end " + end);
        }
        int pos = this.position;
        while (start < end) {
            this.putChar(pos++, src.charAt(start++));
        }
        this.position += sz;
        return this;
    }

    public final TCharBuffer put(String src) {
        return this.put(src, 0, src.length());
    }

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final char[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract char[] getArray();

    abstract int getArrayOffset();

    public abstract TCharBuffer compact();

    @Override
    public abstract boolean isDirect();

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + this.getChar(pos++);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TCharBuffer)) {
            return false;
        }
        TCharBuffer other = (TCharBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getChar(a++) == other.getChar(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TCharBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Character.compare(this.getChar(a++), other.getChar(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    @Override
    public String toString() {
        char[] chars = new char[this.limit - this.position];
        int pos = this.position;
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.getChar(pos++);
        }
        return new String(chars);
    }

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public final char charAt(int index) {
        return this.get(index);
    }

    @Override
    public abstract TCharBuffer subSequence(int var1, int var2);

    @Override
    public TCharBuffer append(CharSequence csq) {
        return this.put(csq.toString());
    }

    @Override
    public TCharBuffer append(CharSequence csq, int start, int end) {
        return this.put(csq.subSequence(start, end).toString());
    }

    @Override
    public TCharBuffer append(char c) {
        return this.put(c);
    }

    public abstract TByteOrder order();

    @Override
    public final TCharBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TCharBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TCharBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TCharBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TCharBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TCharBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TCharBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

