/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.regex;

import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractCharClass;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLexer;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPattern;
import java.util.BitSet;

class TCharClass
extends TAbstractCharClass {
    boolean ci;
    boolean uci;
    boolean hasUCI;
    boolean invertedSurrogates;
    boolean inverted;
    boolean hideBits;
    BitSet bits = new BitSet();
    TAbstractCharClass nonBitSet;

    private static void cpdBegin() {
    }

    public TCharClass() {
    }

    public TCharClass(boolean ci, boolean uci) {
        this.ci = ci;
        this.uci = uci;
    }

    public TCharClass(boolean negative, boolean ci, boolean uci) {
        this(ci, uci);
        this.setNegative(negative);
    }

    public TCharClass add(int ch) {
        if (this.ci) {
            if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
                if (!this.inverted) {
                    this.bits.set(TPattern.getSupplement((char)ch));
                } else {
                    this.bits.clear(TPattern.getSupplement((char)ch));
                }
            } else if (this.uci && ch > 128) {
                this.hasUCI = true;
                ch = Character.toLowerCase(Character.toUpperCase(ch));
            }
        }
        if (TLexer.isHighSurrogate(ch) || TLexer.isLowSurrogate(ch)) {
            if (!this.invertedSurrogates) {
                this.lowHighSurrogates.set(ch - 55296);
            } else {
                this.lowHighSurrogates.clear(ch - 55296);
            }
        }
        if (!this.inverted) {
            this.bits.set(ch);
        } else {
            this.bits.clear(ch);
        }
        if (!this.mayContainSupplCodepoints && Character.isSupplementaryCodePoint(ch)) {
            this.mayContainSupplCodepoints = true;
        }
        return this;
    }

    public TCharClass add(final TAbstractCharClass cc) {
        if (!this.mayContainSupplCodepoints && cc.mayContainSupplCodepoints) {
            this.mayContainSupplCodepoints = true;
        }
        if (!this.invertedSurrogates) {
            if (cc.altSurrogates) {
                this.lowHighSurrogates.xor(cc.getLowHighSurrogates());
                this.lowHighSurrogates.and(cc.getLowHighSurrogates());
                this.altSurrogates = !this.altSurrogates;
                this.invertedSurrogates = true;
            } else {
                this.lowHighSurrogates.or(cc.getLowHighSurrogates());
            }
        } else if (cc.altSurrogates) {
            this.lowHighSurrogates.and(cc.getLowHighSurrogates());
        } else {
            this.lowHighSurrogates.andNot(cc.getLowHighSurrogates());
        }
        if (!this.hideBits && cc.getBits() != null) {
            if (!this.inverted) {
                if (cc.isNegative()) {
                    this.bits.xor(cc.getBits());
                    this.bits.and(cc.getBits());
                    this.alt = !this.alt;
                    this.inverted = true;
                } else {
                    this.bits.or(cc.getBits());
                }
            } else if (cc.isNegative()) {
                this.bits.and(cc.getBits());
            } else {
                this.bits.andNot(cc.getBits());
            }
        } else {
            final boolean curAlt = this.alt;
            if (this.nonBitSet == null) {
                this.nonBitSet = curAlt && !this.inverted && this.bits.isEmpty() ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return cc.contains(ch);
                    }
                } : (curAlt ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return !(curAlt ^ TCharClass.this.bits.get(ch)) && !(curAlt ^ TCharClass.this.inverted ^ cc.contains(ch));
                    }
                } : new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return curAlt ^ TCharClass.this.bits.get(ch) || curAlt ^ TCharClass.this.inverted ^ cc.contains(ch);
                    }
                });
                this.hideBits = true;
            } else {
                final TAbstractCharClass nb = this.nonBitSet;
                this.nonBitSet = curAlt ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return !(curAlt ^ (nb.contains(ch) || cc.contains(ch)));
                    }
                } : new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return curAlt ^ (nb.contains(ch) || cc.contains(ch));
                    }
                };
            }
        }
        return this;
    }

    public TCharClass add(int st, int end) {
        if (st > end) {
            throw new IllegalArgumentException();
        }
        if (!(this.ci || end >= 55296 && st <= 57343)) {
            if (!this.inverted) {
                this.bits.set(st, end + 1);
            } else {
                this.bits.clear(st, end + 1);
            }
        } else {
            for (int i = st; i < end + 1; ++i) {
                this.add(i);
            }
        }
        return this;
    }

    public void union(final TAbstractCharClass clazz) {
        if (!this.mayContainSupplCodepoints && clazz.mayContainSupplCodepoints) {
            this.mayContainSupplCodepoints = true;
        }
        if (clazz.hasUCI()) {
            this.hasUCI = true;
        }
        if (this.altSurrogates ^ clazz.altSurrogates) {
            if (this.altSurrogates) {
                this.lowHighSurrogates.andNot(clazz.getLowHighSurrogates());
            } else {
                this.lowHighSurrogates.xor(clazz.getLowHighSurrogates());
                this.lowHighSurrogates.and(clazz.getLowHighSurrogates());
                this.altSurrogates = true;
            }
        } else if (this.altSurrogates) {
            this.lowHighSurrogates.and(clazz.getLowHighSurrogates());
        } else {
            this.lowHighSurrogates.or(clazz.getLowHighSurrogates());
        }
        if (!this.hideBits && clazz.getBits() != null) {
            if (this.alt ^ clazz.isNegative()) {
                if (this.alt) {
                    this.bits.andNot(clazz.getBits());
                } else {
                    this.bits.xor(clazz.getBits());
                    this.bits.and(clazz.getBits());
                    this.alt = true;
                }
            } else if (this.alt) {
                this.bits.and(clazz.getBits());
            } else {
                this.bits.or(clazz.getBits());
            }
        } else {
            final boolean curAlt = this.alt;
            if (this.nonBitSet == null) {
                this.nonBitSet = !this.inverted && this.bits.isEmpty() ? (curAlt ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return !clazz.contains(ch);
                    }
                } : new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return clazz.contains(ch);
                    }
                }) : (curAlt ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return !clazz.contains(ch) && !(curAlt ^ TCharClass.this.bits.get(ch));
                    }
                } : new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return clazz.contains(ch) || curAlt ^ TCharClass.this.bits.get(ch);
                    }
                });
                this.hideBits = true;
            } else {
                final TAbstractCharClass nb = this.nonBitSet;
                this.nonBitSet = curAlt ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return !(curAlt ^ nb.contains(ch)) && !clazz.contains(ch);
                    }
                } : new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return curAlt ^ nb.contains(ch) || clazz.contains(ch);
                    }
                };
            }
        }
    }

    public void intersection(final TAbstractCharClass clazz) {
        if (!this.mayContainSupplCodepoints && clazz.mayContainSupplCodepoints) {
            this.mayContainSupplCodepoints = true;
        }
        if (clazz.hasUCI()) {
            this.hasUCI = true;
        }
        if (this.altSurrogates ^ clazz.altSurrogates) {
            if (this.altSurrogates) {
                this.lowHighSurrogates.xor(clazz.getLowHighSurrogates());
                this.lowHighSurrogates.and(clazz.getLowHighSurrogates());
                this.altSurrogates = false;
            } else {
                this.lowHighSurrogates.andNot(clazz.getLowHighSurrogates());
            }
        } else if (this.altSurrogates) {
            this.lowHighSurrogates.or(clazz.getLowHighSurrogates());
        } else {
            this.lowHighSurrogates.and(clazz.getLowHighSurrogates());
        }
        if (!this.hideBits && clazz.getBits() != null) {
            if (this.alt ^ clazz.isNegative()) {
                if (this.alt) {
                    this.bits.xor(clazz.getBits());
                    this.bits.and(clazz.getBits());
                    this.alt = false;
                } else {
                    this.bits.andNot(clazz.getBits());
                }
            } else if (this.alt) {
                this.bits.or(clazz.getBits());
            } else {
                this.bits.and(clazz.getBits());
            }
        } else {
            final boolean curAlt = this.alt;
            if (this.nonBitSet == null) {
                this.nonBitSet = !this.inverted && this.bits.isEmpty() ? (curAlt ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return !clazz.contains(ch);
                    }
                } : new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return clazz.contains(ch);
                    }
                }) : (curAlt ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return !clazz.contains(ch) || !(curAlt ^ TCharClass.this.bits.get(ch));
                    }
                } : new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return clazz.contains(ch) && curAlt ^ TCharClass.this.bits.get(ch);
                    }
                });
                this.hideBits = true;
            } else {
                final TAbstractCharClass nb = this.nonBitSet;
                this.nonBitSet = curAlt ? new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return !(curAlt ^ nb.contains(ch)) || !clazz.contains(ch);
                    }
                } : new TAbstractCharClass(){

                    @Override
                    public boolean contains(int ch) {
                        return curAlt ^ nb.contains(ch) && clazz.contains(ch);
                    }
                };
            }
        }
    }

    @Override
    public boolean contains(int ch) {
        if (this.nonBitSet == null) {
            return this.alt ^ this.bits.get(ch);
        }
        return this.alt ^ this.nonBitSet.contains(ch);
    }

    @Override
    protected BitSet getBits() {
        if (this.hideBits) {
            return null;
        }
        return this.bits;
    }

    @Override
    protected BitSet getLowHighSurrogates() {
        return this.lowHighSurrogates;
    }

    @Override
    public TAbstractCharClass getInstance() {
        if (this.nonBitSet == null) {
            final BitSet bs = this.getBits();
            TAbstractCharClass res = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return this.alt ^ bs.get(ch);
                }

                public String toString() {
                    StringBuilder temp = new StringBuilder();
                    int i = bs.nextSetBit(0);
                    while (i >= 0) {
                        temp.append(Character.toChars(i));
                        temp.append('|');
                        i = bs.nextSetBit(i + 1);
                    }
                    if (temp.length() > 0) {
                        temp.deleteCharAt(temp.length() - 1);
                    }
                    return temp.toString();
                }
            };
            return res.setNegative(this.isNegative());
        }
        return this;
    }

    public String toString() {
        StringBuilder temp = new StringBuilder();
        int i = this.bits.nextSetBit(0);
        while (i >= 0) {
            temp.append(Character.toChars(i));
            temp.append('|');
            i = this.bits.nextSetBit(i + 1);
        }
        if (temp.length() > 0) {
            temp.deleteCharAt(temp.length() - 1);
        }
        return temp.toString();
    }

    @Override
    public boolean hasUCI() {
        return this.hasUCI;
    }

    private static void cpdEnd() {
    }
}

