/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.regex;

import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLeafSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TMatchResultImpl;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplRangeSet;

class TSupplCharSet
extends TLeafSet {
    private char high;
    private char low;
    private int ch;

    public TSupplCharSet(int ch) {
        this.charCount = 2;
        this.ch = ch;
        char[] chUTF16 = Character.toChars(ch);
        this.high = chUTF16[0];
        this.low = chUTF16[1];
    }

    @Override
    public int accepts(int strIndex, CharSequence testString) {
        char high = testString.charAt(strIndex++);
        char low = testString.charAt(strIndex);
        return this.high == high && this.low == low ? 2 : -1;
    }

    @Override
    public int find(int strIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (testString instanceof String) {
            String testStr = (String)testString;
            int strLength = matchResult.getRightBound();
            while (strIndex < strLength) {
                if ((strIndex = testStr.indexOf(this.high, strIndex)) < 0) {
                    return -1;
                }
                if (++strIndex >= strLength) continue;
                char ch = testStr.charAt(strIndex);
                if (this.low == ch && this.next.matches(strIndex + 1, testString, matchResult) >= 0) {
                    return --strIndex;
                }
                ++strIndex;
            }
            return -1;
        }
        return super.find(strIndex, testString, matchResult);
    }

    @Override
    public int findBack(int strIndex, int lastIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (testString instanceof String) {
            String testStr = (String)testString;
            while (lastIndex >= strIndex) {
                lastIndex = testStr.lastIndexOf(this.low, lastIndex);
                if (--lastIndex < 0 || lastIndex < strIndex) {
                    return -1;
                }
                if (this.high == testStr.charAt(lastIndex) && this.next.matches(lastIndex + 2, testString, matchResult) >= 0) {
                    return lastIndex;
                }
                --lastIndex;
            }
            return -1;
        }
        return super.findBack(strIndex, lastIndex, testString, matchResult);
    }

    @Override
    protected String getName() {
        return "" + this.high + this.low;
    }

    protected int getCodePoint() {
        return this.ch;
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (set instanceof TSupplCharSet) {
            return ((TSupplCharSet)set).getCodePoint() == this.ch;
        }
        if (set instanceof TSupplRangeSet) {
            return ((TSupplRangeSet)set).contains(this.ch);
        }
        if (set instanceof TCharSet) {
            return false;
        }
        return !(set instanceof TRangeSet);
    }
}

