/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.support;

import com.antgroup.antchain.myjava.classlib.ReflectionContext;
import com.antgroup.antchain.myjava.classlib.ReflectionSupplier;
import com.antgroup.antchain.myjava.classlib.support.Reflectable;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ReflectionSupplierImpl
implements ReflectionSupplier {
    @Override
    public Collection<String> getAccessibleFields(ReflectionContext context, String className) {
        ClassReader cls = context.getClassSource().get(className);
        if (cls == null) {
            return Collections.emptyList();
        }
        HashSet<String> fields = new HashSet<String>();
        for (FieldReader field : cls.getFields()) {
            if (field.getAnnotations().get(Reflectable.class.getName()) == null) continue;
            fields.add(field.getName());
        }
        return fields;
    }

    @Override
    public Collection<MethodDescriptor> getAccessibleMethods(ReflectionContext context, String className) {
        ClassReader cls = context.getClassSource().get(className);
        if (cls == null) {
            return Collections.emptyList();
        }
        HashSet<MethodDescriptor> methods = new HashSet<MethodDescriptor>();
        for (MethodReader method : cls.getMethods()) {
            if (method.getAnnotations().get(Reflectable.class.getName()) != null) {
                methods.add(method.getDescriptor());
                continue;
            }
            if (!"writeReplace".equals(method.getName()) || !method.getResultType().isObject(SerializedLambda.class)) continue;
            methods.add(method.getDescriptor());
        }
        return methods;
    }
}

