/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.util.stream.TDoubleStream;
import java.util.NoSuchElementException;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;

public class TOptionalDouble {
    private static TOptionalDouble emptyInstance;
    private final double value;

    private TOptionalDouble(double value) {
        this.value = value;
    }

    public static TOptionalDouble empty() {
        if (emptyInstance == null) {
            emptyInstance = new TOptionalDouble(0.0);
        }
        return emptyInstance;
    }

    public static TOptionalDouble of(double value) {
        return new TOptionalDouble(value);
    }

    public double getAsDouble() {
        if (this == emptyInstance) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean isPresent() {
        return this != emptyInstance;
    }

    public boolean isEmpty() {
        return this == emptyInstance;
    }

    public void ifPresent(DoubleConsumer consumer) {
        if (this != emptyInstance) {
            consumer.accept(this.value);
        }
    }

    public double orElse(double other) {
        return this != emptyInstance ? this.value : other;
    }

    public double orElseGet(DoubleSupplier other) {
        return this != emptyInstance ? this.value : other.getAsDouble();
    }

    public void ifPresentOrElse(DoubleConsumer action, Runnable emptyAction) {
        if (this == emptyInstance) {
            emptyAction.run();
        } else {
            action.accept(this.value);
        }
    }

    public <X extends Throwable> double orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this == emptyInstance) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    public double orElseThrow() {
        if (this == emptyInstance) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public TDoubleStream stream() {
        if (this == emptyInstance) {
            return TDoubleStream.empty();
        }
        return TDoubleStream.of(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this == emptyInstance || obj == emptyInstance || !(obj instanceof TOptionalDouble)) {
            return false;
        }
        return ((TOptionalDouble)obj).value == this.value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return this.isPresent() ? "OptionalDouble.of(" + this.value + ")" : "OptionalDouble.empty()";
    }
}

