/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.stream.impl;

import com.antgroup.antchain.myjava.classlib.java.util.stream.impl.TSimpleStreamImpl;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class TStreamOverSpliteratorSupplier<T>
extends TSimpleStreamImpl<T> {
    private Supplier<Spliterator<T>> supplier;
    private int characteristics;
    private Spliterator<T> spliterator;

    public TStreamOverSpliteratorSupplier(Supplier<Spliterator<T>> supplier, int characteristics) {
        this.supplier = supplier;
        this.characteristics = characteristics;
    }

    private void init() {
        if (this.spliterator == null) {
            this.spliterator = this.supplier.get();
            this.supplier = null;
        }
    }

    @Override
    public boolean next(Predicate<? super T> consumer) {
        AdapterAction<? super T> action = new AdapterAction<T>(consumer);
        this.init();
        while (this.spliterator.tryAdvance(action)) {
            if (action.wantsMore) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int estimateSize() {
        this.init();
        return (int)this.spliterator.estimateSize();
    }

    @Override
    public long count() {
        this.init();
        return this.spliterator.hasCharacteristics(64) ? (long)((int)this.spliterator.estimateSize()) : super.count();
    }

    static class AdapterAction<T>
    implements Consumer<T> {
        private Predicate<? super T> consumer;
        boolean wantsMore;

        AdapterAction(Predicate<? super T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(T t) {
            this.wantsMore = this.consumer.test(t);
        }
    }
}

