/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio.charset.impl;

import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharset;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCoderResult;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.impl.TBufferedEncoder;
import com.antgroup.antchain.myjava.interop.NoMetadata;

@NoMetadata
public class TUTF8Encoder
extends TBufferedEncoder {
    TUTF8Encoder(TCharset cs) {
        super(cs, 2.0f, 4.0f);
    }

    @Override
    protected TCoderResult arrayEncode(char[] inArray, int inPos, int inSize, byte[] outArray, int outPos, int outSize, TBufferedEncoder.Controller controller) {
        TCoderResult result = null;
        while (inPos < inSize && outPos < outSize) {
            char ch;
            if ((ch = inArray[inPos++]) < '\u0080') {
                outArray[outPos++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                if (outPos + 2 > outSize) {
                    --inPos;
                    if (controller.hasMoreOutput(2)) break;
                    result = TCoderResult.OVERFLOW;
                    break;
                }
                outArray[outPos++] = (byte)(0xC0 | ch >> 6);
                outArray[outPos++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (!Character.isSurrogate(ch)) {
                if (outPos + 3 > outSize) {
                    --inPos;
                    if (controller.hasMoreOutput(3)) break;
                    result = TCoderResult.OVERFLOW;
                    break;
                }
                outArray[outPos++] = (byte)(0xE0 | ch >> 12);
                outArray[outPos++] = (byte)(0x80 | ch >> 6 & 0x3F);
                outArray[outPos++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                char low;
                if (inPos >= inSize) {
                    if (controller.hasMoreInput()) break;
                    result = TCoderResult.UNDERFLOW;
                    break;
                }
                if (!Character.isLowSurrogate(low = inArray[inPos++])) {
                    inPos -= 2;
                    result = TCoderResult.malformedForLength(1);
                    break;
                }
                if (outPos + 4 > outSize) {
                    inPos -= 2;
                    if (controller.hasMoreOutput(4)) break;
                    result = TCoderResult.OVERFLOW;
                    break;
                }
                int codePoint = Character.toCodePoint(ch, low);
                outArray[outPos++] = (byte)(0xF0 | codePoint >> 18);
                outArray[outPos++] = (byte)(0x80 | codePoint >> 12 & 0x3F);
                outArray[outPos++] = (byte)(0x80 | codePoint >> 6 & 0x3F);
                outArray[outPos++] = (byte)(0x80 | codePoint & 0x3F);
                continue;
            }
            result = TCoderResult.malformedForLength(1);
            break;
        }
        controller.setInPosition(inPos);
        controller.setOutPosition(outPos);
        return result;
    }
}

