/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.text;

import com.antgroup.antchain.myjava.classlib.java.io.TSerializable;
import com.antgroup.antchain.myjava.classlib.java.lang.TCloneable;
import com.antgroup.antchain.myjava.classlib.java.util.TLocale;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.util.Arrays;
import java.util.Objects;

@NoMetadata
public class TDateFormatSymbols
implements TSerializable,
TCloneable {
    private TLocale locale;
    private String localPatternChars;
    String[] ampms;
    String[] eras;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    String[][] zoneStrings;

    public TDateFormatSymbols() {
        this(TLocale.getDefault());
    }

    public TDateFormatSymbols(TLocale locale) {
        this.locale = locale;
    }

    public Object clone() {
        TDateFormatSymbols symbols = new TDateFormatSymbols(this.locale);
        if (this.ampms != null) {
            symbols.ampms = Arrays.copyOf(this.ampms, this.ampms.length);
        }
        if (this.eras != null) {
            symbols.eras = Arrays.copyOf(this.eras, this.eras.length);
        }
        if (this.months != null) {
            symbols.months = Arrays.copyOf(this.months, this.months.length);
        }
        if (this.shortMonths != null) {
            symbols.shortMonths = Arrays.copyOf(this.shortMonths, this.shortMonths.length);
        }
        if (this.shortWeekdays != null) {
            symbols.shortWeekdays = Arrays.copyOf((String[])this.shortWeekdays.clone(), this.shortWeekdays.length);
        }
        if (this.weekdays != null) {
            symbols.weekdays = Arrays.copyOf(this.weekdays, this.weekdays.length);
        }
        if (this.zoneStrings != null) {
            symbols.zoneStrings = new String[this.zoneStrings.length][];
            for (int i = 0; i < this.zoneStrings.length; ++i) {
                symbols.zoneStrings[i] = Arrays.copyOf(this.zoneStrings[i], this.zoneStrings[i].length);
            }
        }
        return symbols;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TDateFormatSymbols)) {
            return false;
        }
        TDateFormatSymbols obj = (TDateFormatSymbols)object;
        if (!this.locale.equals(obj.locale)) {
            return false;
        }
        if (!Objects.equals(this.localPatternChars, obj.localPatternChars)) {
            return false;
        }
        if (!Arrays.equals(this.ampms, obj.ampms)) {
            return false;
        }
        if (!Arrays.equals(this.eras, obj.eras)) {
            return false;
        }
        if (!Arrays.equals(this.months, obj.months)) {
            return false;
        }
        if (!Arrays.equals(this.shortMonths, obj.shortMonths)) {
            return false;
        }
        if (!Arrays.equals(this.shortWeekdays, obj.shortWeekdays)) {
            return false;
        }
        if (!Arrays.equals(this.weekdays, obj.weekdays)) {
            return false;
        }
        return Arrays.equals((Object[])this.zoneStrings, (Object[])obj.zoneStrings);
    }

    public String[] getAmPmStrings() {
        return new String[]{"AM", "PM"};
    }

    public String[] getEras() {
        return new String[]{"BC", "AD"};
    }

    public String getLocalPatternChars() {
        if (this.localPatternChars == null) {
            this.localPatternChars = "";
        }
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    }

    public String[] getShortMonths() {
        return new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    }

    public String[] getShortWeekdays() {
        return new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    }

    public String[] getWeekdays() {
        return new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    }

    public String[][] getZoneStrings() {
        if (this.zoneStrings == null) {
            return new String[0][];
        }
        String[][] clone = new String[this.zoneStrings.length][];
        int i = this.zoneStrings.length;
        while (--i >= 0) {
            clone[i] = (String[])this.zoneStrings[i].clone();
        }
        return clone;
    }

    public int hashCode() {
        int hashCode = this.localPatternChars.hashCode();
        for (String string : this.ampms) {
            hashCode += string.hashCode();
        }
        for (String string : this.eras) {
            hashCode += string.hashCode();
        }
        for (String string : this.months) {
            hashCode += string.hashCode();
        }
        for (String string : this.shortMonths) {
            hashCode += string.hashCode();
        }
        for (String string : this.shortWeekdays) {
            hashCode += string.hashCode();
        }
        for (String string : this.weekdays) {
            hashCode += string.hashCode();
        }
        for (String string : this.zoneStrings) {
            for (int j = 0; j < ((String)string).length; ++j) {
                if (string[j] == null) continue;
                hashCode += string[j].hashCode();
            }
        }
        return hashCode;
    }

    public void setAmPmStrings(String[] data) {
        this.ampms = (String[])data.clone();
    }

    public void setEras(String[] data) {
        this.eras = (String[])data.clone();
    }

    public void setLocalPatternChars(String data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.localPatternChars = data;
    }

    public void setMonths(String[] data) {
        this.months = (String[])data.clone();
    }

    public void setShortMonths(String[] data) {
        this.shortMonths = (String[])data.clone();
    }

    public void setShortWeekdays(String[] data) {
        this.shortWeekdays = (String[])data.clone();
    }

    public void setWeekdays(String[] data) {
        this.weekdays = (String[])data.clone();
    }

    public void setZoneStrings(String[][] data) {
        this.zoneStrings = (String[][])data.clone();
    }

    public static TDateFormatSymbols getInstance(TLocale locale) {
        return new TDateFormatSymbols(locale);
    }
}

