/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.regex;

import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TMatchResultImpl;

class TWordBoundary
extends TAbstractSet {
    boolean positive;

    public TWordBoundary(boolean positive) {
        this.positive = positive;
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        char ch1 = stringIndex >= matchResult.getRightBound() ? (char)' ' : (char)testString.charAt(stringIndex);
        char ch2 = stringIndex == 0 ? (char)' ' : (char)testString.charAt(stringIndex - 1);
        int leftBound = matchResult.hasTransparentBounds() ? 0 : matchResult.getLeftBound();
        boolean left = ch1 == ' ' || this.isSpace(ch1, stringIndex, leftBound, testString);
        boolean right = ch2 == ' ' || this.isSpace(ch2, stringIndex - 1, leftBound, testString);
        return left ^ right ^ this.positive ? -1 : this.next.matches(stringIndex, testString, matchResult);
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl matchResult) {
        return false;
    }

    @Override
    protected String getName() {
        return "WordBoundary";
    }

    private boolean isSpace(char ch, int index, int leftBound, CharSequence testString) {
        if (Character.isLetterOrDigit(ch) || ch == '_') {
            return false;
        }
        if (Character.getType(ch) == 6) {
            while (--index >= leftBound) {
                ch = testString.charAt(index);
                if (Character.isLetterOrDigit(ch)) {
                    return false;
                }
                if (Character.getType(ch) == 6) continue;
                return true;
            }
        }
        return true;
    }
}

