/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl.optimization;

import com.antgroup.antchain.myjava.common.DisjointSet;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.InstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;
import com.antgroup.antchain.myjava.model.util.PhiUpdater;
import com.antgroup.antchain.myjava.model.util.UsageExtractor;

public class ArrayElimination {
    private Program program;
    private int[] varClasses;
    private int[] constantValues;
    private boolean[] constants;
    private boolean[] unsafeArrays;
    private int[] arraySizes;
    private boolean hasModifications;

    public void apply(Program program, MethodReference methodReference) {
        this.program = program;
        this.findVarClasses();
        this.findConstantVariables();
        this.findSafeArrays();
        this.removeSafeArrays();
        if (this.hasModifications) {
            Variable[] parameters = new Variable[methodReference.parameterCount() + 1];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = program.variableAt(i);
            }
            new PhiUpdater().updatePhis(program, parameters);
        }
    }

    private void findVarClasses() {
        DisjointSet varClasses = new DisjointSet();
        for (int i = 0; i < this.program.variableCount(); ++i) {
            varClasses.create();
        }
        for (BasicBlock block : this.program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                int assignee;
                int receiver;
                if (instruction instanceof AssignInstruction) {
                    AssignInstruction assign = (AssignInstruction)instruction;
                    receiver = assign.getReceiver().getIndex();
                    assignee = assign.getAssignee().getIndex();
                } else {
                    if (!(instruction instanceof UnwrapArrayInstruction)) continue;
                    UnwrapArrayInstruction unwrap = (UnwrapArrayInstruction)instruction;
                    receiver = unwrap.getReceiver().getIndex();
                    assignee = unwrap.getArray().getIndex();
                }
                varClasses.union(receiver, assignee);
            }
        }
        this.varClasses = varClasses.pack(this.program.variableCount());
    }

    private void findConstantVariables() {
        int[] constantValuesByClasses = new int[this.program.variableCount()];
        boolean[] constantsByClasses = new boolean[this.program.variableCount()];
        for (BasicBlock block : this.program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                if (!(instruction instanceof IntegerConstantInstruction)) continue;
                IntegerConstantInstruction constant = (IntegerConstantInstruction)instruction;
                int receiver = this.varClasses[constant.getReceiver().getIndex()];
                constantsByClasses[receiver] = true;
                constantValuesByClasses[receiver] = constant.getConstant();
            }
        }
        this.constantValues = new int[this.program.variableCount()];
        this.constants = new boolean[this.program.variableCount()];
        for (int i = 0; i < this.program.variableCount(); ++i) {
            this.constantValues[i] = constantValuesByClasses[this.varClasses[i]];
            this.constants[i] = constantsByClasses[this.varClasses[i]];
        }
    }

    private void findSafeArrays() {
        boolean[] unsafeArraysByClasses = new boolean[this.program.variableCount()];
        int[] arraySizesByClasses = new int[this.program.variableCount()];
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        UsageExtractor useExtractor = new UsageExtractor();
        for (BasicBlock block : this.program.getBasicBlocks()) {
            for (Phi phi : block.getPhis()) {
                unsafeArraysByClasses[this.varClasses[phi.getReceiver().getIndex()]] = true;
                for (Incoming incoming : phi.getIncomings()) {
                    unsafeArraysByClasses[this.varClasses[incoming.getValue().getIndex()]] = true;
                }
            }
            for (Instruction instruction : block) {
                if (instruction instanceof GetElementInstruction) {
                    GetElementInstruction getElement = (GetElementInstruction)instruction;
                    unsafeArraysByClasses[this.varClasses[getElement.getReceiver().getIndex()]] = true;
                    continue;
                }
                if (instruction instanceof PutElementInstruction) {
                    PutElementInstruction putElement = (PutElementInstruction)instruction;
                    unsafeArraysByClasses[this.varClasses[putElement.getValue().getIndex()]] = true;
                    if (this.constants[putElement.getIndex().getIndex()]) continue;
                    unsafeArraysByClasses[this.varClasses[putElement.getIndex().getIndex()]] = true;
                    continue;
                }
                if (instruction instanceof ConstructArrayInstruction) {
                    ConstructArrayInstruction construct = (ConstructArrayInstruction)instruction;
                    int receiver = this.varClasses[construct.getReceiver().getIndex()];
                    if (!this.constants[construct.getSize().getIndex()]) {
                        unsafeArraysByClasses[receiver] = true;
                        continue;
                    }
                    arraySizesByClasses[receiver] = this.constantValues[construct.getSize().getIndex()];
                    continue;
                }
                if (instruction instanceof AssignInstruction || instruction instanceof UnwrapArrayInstruction) continue;
                instruction.acceptVisitor((InstructionVisitor)defExtractor);
                instruction.acceptVisitor((InstructionVisitor)useExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    unsafeArraysByClasses[this.varClasses[var.getIndex()]] = true;
                }
                for (Variable var : useExtractor.getUsedVariables()) {
                    unsafeArraysByClasses[this.varClasses[var.getIndex()]] = true;
                }
            }
        }
        this.unsafeArrays = new boolean[this.program.variableCount()];
        this.arraySizes = new int[this.program.variableCount()];
        for (int i = 0; i < this.program.variableCount(); ++i) {
            this.unsafeArrays[i] = unsafeArraysByClasses[this.varClasses[i]];
            this.arraySizes[i] = arraySizesByClasses[this.varClasses[i]];
        }
    }

    private void removeSafeArrays() {
        int[][] arrayItemsAsVariablesByClass = new int[this.program.variableCount()][];
        for (int i = 0; i < arrayItemsAsVariablesByClass.length; ++i) {
            int varClass = this.varClasses[i];
            if (arrayItemsAsVariablesByClass[varClass] != null || this.unsafeArrays[i]) continue;
            int size = this.arraySizes[i];
            arrayItemsAsVariablesByClass[varClass] = new int[size];
            for (int j = 0; j < size; ++j) {
                arrayItemsAsVariablesByClass[varClass][j] = this.program.createVariable().getIndex();
            }
        }
        int[][] arrayItemsAsVariables = new int[arrayItemsAsVariablesByClass.length][];
        for (int i = 0; i < arrayItemsAsVariables.length; ++i) {
            arrayItemsAsVariables[i] = arrayItemsAsVariablesByClass[this.varClasses[i]];
        }
        for (BasicBlock block : this.program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                AssignInstruction assign;
                AssignInstruction assign2;
                Variable var;
                int index;
                if (instruction instanceof GetElementInstruction) {
                    GetElementInstruction getElement = (GetElementInstruction)instruction;
                    int array = getElement.getArray().getIndex();
                    if (this.unsafeArrays[array]) continue;
                    index = this.constantValues[getElement.getIndex().getIndex()];
                    var = this.program.variableAt(arrayItemsAsVariables[array][index]);
                    assign2 = new AssignInstruction();
                    assign2.setReceiver(getElement.getReceiver());
                    assign2.setAssignee(var);
                    assign2.setLocation(getElement.getLocation());
                    getElement.replace((Instruction)assign2);
                    this.hasModifications = true;
                    continue;
                }
                if (instruction instanceof PutElementInstruction) {
                    PutElementInstruction putElement = (PutElementInstruction)instruction;
                    int array = putElement.getArray().getIndex();
                    if (this.unsafeArrays[array]) continue;
                    index = this.constantValues[putElement.getIndex().getIndex()];
                    var = this.program.variableAt(arrayItemsAsVariables[array][index]);
                    assign2 = new AssignInstruction();
                    assign2.setReceiver(var);
                    assign2.setAssignee(putElement.getValue());
                    assign2.setLocation(putElement.getLocation());
                    putElement.replace((Instruction)assign2);
                    this.hasModifications = true;
                    continue;
                }
                if (instruction instanceof ConstructArrayInstruction) {
                    ConstructArrayInstruction construct = (ConstructArrayInstruction)instruction;
                    if (this.unsafeArrays[construct.getReceiver().getIndex()]) continue;
                    int[] vars = arrayItemsAsVariables[construct.getReceiver().getIndex()];
                    for (int i = 0; i < vars.length; ++i) {
                        Instruction constantInsn = this.createDefaultConstantInstruction(construct.getItemType(), this.program.variableAt(vars[i]));
                        constantInsn.setLocation(construct.getLocation());
                        construct.insertPrevious(constantInsn);
                    }
                    construct.delete();
                    this.hasModifications = true;
                    continue;
                }
                if (instruction instanceof UnwrapArrayInstruction) {
                    UnwrapArrayInstruction unwrap = (UnwrapArrayInstruction)instruction;
                    if (this.unsafeArrays[unwrap.getArray().getIndex()]) continue;
                    unwrap.delete();
                    this.hasModifications = true;
                    continue;
                }
                if (!(instruction instanceof AssignInstruction) || this.unsafeArrays[(assign = (AssignInstruction)instruction).getAssignee().getIndex()]) continue;
                assign.delete();
                this.hasModifications = true;
            }
        }
    }

    private Instruction createDefaultConstantInstruction(ValueType valueType, Variable receiver) {
        if (valueType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)valueType).getKind()) {
                case BOOLEAN: 
                case CHARACTER: 
                case BYTE: 
                case SHORT: 
                case INTEGER: {
                    IntegerConstantInstruction result = new IntegerConstantInstruction();
                    result.setReceiver(receiver);
                    return result;
                }
                case LONG: {
                    LongConstantInstruction result = new LongConstantInstruction();
                    result.setReceiver(receiver);
                    return result;
                }
                case FLOAT: {
                    FloatConstantInstruction result = new FloatConstantInstruction();
                    result.setReceiver(receiver);
                    return result;
                }
                case DOUBLE: {
                    DoubleConstantInstruction result = new DoubleConstantInstruction();
                    result.setReceiver(receiver);
                    return result;
                }
            }
        }
        NullConstantInstruction result = new NullConstantInstruction();
        result.setReceiver(receiver);
        return result;
    }
}

