/*
 * Decompiled with CFR 0.152.
 */
package com.pensio.api;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class HTTPHelper {
    public InputStream doPost(String urlString, Map<String, String> postVars, String username, String password, String sdkVersion) throws IOException {
        URL url = new URL(urlString);
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setRequestProperty("x-altapay-client-version", sdkVersion);
        urlConn.setRequestProperty("User-Agent", sdkVersion);
        if (username != null) {
            String encoded = new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes()));
            urlConn.setRequestProperty("Authorization", "Basic " + encoded);
        }
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        Object content = "";
        boolean isFirst = true;
        for (Map.Entry<String, String> e : postVars.entrySet()) {
            content = (String)content + (isFirst ? "" : "&") + e.getKey() + "=" + URLEncoder.encode(e.getValue(), "utf-8");
            isFirst = false;
        }
        printout.writeBytes((String)content);
        printout.flush();
        printout.close();
        return new DataInputStream(urlConn.getInputStream());
    }

    public InputStream doGet(String urlString, Map<String, String> getVars, String username, String password, String sdkVersion) throws IOException {
        Object query = "";
        boolean isFirst = true;
        for (Map.Entry<String, String> e : getVars.entrySet()) {
            query = (String)query + (isFirst ? "?" : "&") + e.getKey() + "=" + URLEncoder.encode(e.getValue(), StandardCharsets.UTF_8.name());
            isFirst = false;
        }
        URL url = new URL(urlString + (String)query);
        URLConnection urlConn = url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        urlConn.setRequestProperty("x-altapay-client-version", sdkVersion);
        urlConn.setRequestProperty("User-Agent", sdkVersion);
        if (username != null) {
            String encoded = new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes()));
            urlConn.setRequestProperty("Authorization", "Basic " + encoded);
        }
        return new DataInputStream(urlConn.getInputStream());
    }
}

