/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.hal.ImmediatelyExpiringCache;
import com.amazonaws.hal.client.HalClient;
import java.util.Map;

public class HalService<T> {
    private String endpoint;
    private String serviceName;
    private Class<T> rootClass;
    private String rootPath;
    private ClientConfiguration clientConfiguration;
    private AWSCredentialsProvider awsCredentialsProvider;
    private Map<String, Object> resourceCache;
    private HalClient halClient;
    public static String DEFAULT_ROOT_PATH = "/";

    public HalService(String endpoint, String serviceName, Class<T> rootClass) {
        this(endpoint, serviceName, rootClass, DEFAULT_ROOT_PATH);
    }

    public HalService(String endpoint, String serviceName, Class<T> rootClass, String rootPath) {
        this.endpoint = endpoint;
        this.serviceName = serviceName;
        this.rootClass = rootClass;
        this.rootPath = rootPath;
    }

    public HalService<T> with(ClientConfiguration clientConfiguration) {
        this.setClientConfiguration(clientConfiguration);
        return this;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public HalService<T> with(AWSCredentialsProvider awsCredentialsProvider) {
        this.setAwsCredentialsProvider(awsCredentialsProvider);
        return this;
    }

    public void setAwsCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    public HalService<T> with(Map<String, Object> resourceCache) {
        this.setResourceCache(resourceCache);
        return this;
    }

    public void setResourceCache(Map<String, Object> resourceCache) {
        this.resourceCache = resourceCache;
    }

    public T getRootResource() {
        return this.getHalClient().getResource(this.rootClass, this.rootPath);
    }

    private HalClient getHalClient() {
        if (this.halClient == null) {
            this.halClient = new HalClient(this.clientConfiguration == null ? new ClientConfiguration() : this.clientConfiguration, this.endpoint, this.serviceName, (AWSCredentialsProvider)(this.awsCredentialsProvider == null ? new DefaultAWSCredentialsProviderChain() : this.awsCredentialsProvider), this.resourceCache == null ? ImmediatelyExpiringCache.getInstance() : this.resourceCache);
        }
        return this.halClient;
    }
}

