/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.ConvertingList;
import com.amazonaws.hal.client.ConvertingMap;
import com.amazonaws.hal.client.MapBackedInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ConversionUtil {
    private static final Log log = LogFactory.getLog(ConversionUtil.class);

    private ConversionUtil() {
    }

    static Type getCollectionType(Type type, int index, Class defaultClass) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments()[index];
        }
        return defaultClass;
    }

    static String getPropertyName(String original) {
        StringBuilder propertyName = new StringBuilder(original.substring("get".length()));
        propertyName.setCharAt(0, Character.toLowerCase(propertyName.charAt(0)));
        return propertyName.toString();
    }

    static Object convert(Type type, Object value) {
        if (value == null) {
            return ConversionUtil.convertFromNull(type);
        }
        if (value instanceof Number) {
            return ConversionUtil.convertFromNumber((Class)type, (Number)value);
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String) {
            return ConversionUtil.convertFromString((Class)type, (String)value);
        }
        if (value instanceof Map) {
            return ConversionUtil.convertFromMap(type, (Map)value);
        }
        if (value instanceof List) {
            return ConversionUtil.convertFromList(type, (List)value);
        }
        throw new RuntimeException("Not sure how to convert " + value + " to a " + type);
    }

    private static Object convertFromNull(Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class clazz = (Class)type;
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return 0;
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return 0L;
        }
        if (Short.TYPE.isAssignableFrom(clazz)) {
            return 0;
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            return 0.0;
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            return Float.valueOf(0.0f);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            return Boolean.FALSE;
        }
        if (Character.TYPE.isAssignableFrom(clazz)) {
            return 0;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            return 0;
        }
        throw new RuntimeException("Unexpected primitive type: " + clazz.getSimpleName());
    }

    private static Object convertFromNumber(Class<?> clazz, Number value) {
        if (String.class.isAssignableFrom(clazz)) {
            return value.toString();
        }
        if (Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
            return value.intValue();
        }
        if (Long.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
            return value.longValue();
        }
        if (Short.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz)) {
            return value.shortValue();
        }
        if (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
            return value.doubleValue();
        }
        if (Float.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz)) {
            return Float.valueOf(value.floatValue());
        }
        if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            return Boolean.valueOf(value.toString());
        }
        if (Character.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            if (value.longValue() <= 255L) {
                return Character.valueOf((char)value.longValue());
            }
            throw new RuntimeException("Not sure how to convert " + value + " to a " + clazz.getSimpleName());
        }
        if (Byte.TYPE.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz)) {
            return value.byteValue();
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return new BigDecimal(value.toString());
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return new BigInteger(String.valueOf(value.longValue()));
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new Date(value.longValue());
        }
        if (clazz.isEnum()) {
            try {
                return Enum.valueOf(clazz, value.toString());
            }
            catch (IllegalArgumentException e) {
                log.error((Object)String.format("'%s' is not a recognized enum value for %s.  Returning default of %s instead.", value, clazz.getName(), clazz.getEnumConstants()[0]));
                return clazz.getEnumConstants()[0];
            }
        }
        throw new RuntimeException("Not sure how to convert " + value + " to a " + clazz.getSimpleName());
    }

    private static Object convertFromString(Class<?> clazz, String value) {
        if (String.class.isAssignableFrom(clazz)) {
            return value;
        }
        if (Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
            return new Integer(value);
        }
        if (Long.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
            return new Long(value);
        }
        if (Short.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz)) {
            return new Short(value);
        }
        if (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
            return new Double(value);
        }
        if (Float.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz)) {
            return new Float(value);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            return Boolean.valueOf(value);
        }
        if (Character.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            return Character.valueOf(value.charAt(0));
        }
        if (Byte.TYPE.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz)) {
            return new Byte(value);
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return new BigDecimal(value);
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return new BigInteger(value);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                try {
                    return DatatypeConverter.parseDateTime((String)value).getTime();
                }
                catch (IllegalArgumentException e1) {
                    throw new RuntimeException("Unexpected date format: " + value + ".  We currently parse xsd:datetime and milliseconds.");
                }
            }
        }
        if (clazz.isEnum()) {
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)String.format("'%s' is not a recognized enum value for %s.  Returning default of %s instead.", value, clazz.getName(), clazz.getEnumConstants()[0]));
                return clazz.getEnumConstants()[0];
            }
        }
        throw new RuntimeException("Not sure how to convert " + value + " to a " + clazz.getSimpleName());
    }

    private static Object convertFromMap(Type type, Map value) {
        if (type instanceof Class && !Map.class.isAssignableFrom((Class)type)) {
            Class typeClass = (Class)type;
            return Proxy.newProxyInstance(typeClass.getClassLoader(), new Class[]{typeClass}, (InvocationHandler)new MapBackedInvocationHandler(type, value));
        }
        return new ConvertingMap(ConversionUtil.getCollectionType(type, 1, Object.class), value);
    }

    private static Object convertFromList(Type type, List value) {
        return new ConvertingList(ConversionUtil.getCollectionType(type, 0, Object.class), value);
    }
}

