/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.ConversionUtil;
import com.amazonaws.hal.client.ConvertingList;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConvertingMap
implements Map {
    private Type type;
    private Map backingMap;

    public ConvertingMap(Type type, Map backingMap) {
        this.type = type;
        this.backingMap = backingMap;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    public Object get(Object key) {
        Object value = this.backingMap.get(key);
        if (this.type instanceof Class) {
            if (!((Class)this.type).isInstance(value)) {
                value = ConversionUtil.convert(this.type, value);
                this.backingMap.put(key, value);
            }
        } else if (!(value instanceof ConvertingMap) && !(value instanceof ConvertingList) && ((value = ConversionUtil.convert(this.type, value)) instanceof ConvertingMap || value instanceof ConvertingList)) {
            this.backingMap.put(key, value);
        }
        return value;
    }

    public Set keySet() {
        return this.backingMap.keySet();
    }

    public Collection values() {
        return new ConvertingList(this.type, new ArrayList(this.backingMap.values()));
    }

    public Set<Map.Entry> entrySet() {
        return new EntrySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private final class ConvertingEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        private ConvertingEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            if (!(ConvertingMap.this.type instanceof Class) || !this.value.getClass().isAssignableFrom((Class)ConvertingMap.this.type)) {
                this.value = ConversionUtil.convert(ConvertingMap.this.type, this.value);
            }
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private final class ConvertingEntryIterator
    implements Iterator<Map.Entry> {
        Iterator<Map.Entry> backingIterator;

        private ConvertingEntryIterator() {
            this.backingIterator = ConvertingMap.this.backingMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public Map.Entry next() {
            Map.Entry entry = this.backingIterator.next();
            return new ConvertingEntry(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry> iterator() {
            return new ConvertingEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return ConvertingMap.this.backingMap.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

