/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.hal.client.AcceptHalJsonRequestHandler;
import com.amazonaws.hal.client.HalJsonResourceUnmarshaller;
import com.amazonaws.hal.client.HalResource;
import com.amazonaws.hal.client.HalResourceInvocationHandler;
import com.amazonaws.hal.client.OptionalJsonResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONObject;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HalClient
extends AmazonWebServiceClient {
    private AWSCredentialsProvider awsCredentialsProvider;
    private List<JsonErrorUnmarshaller> exceptionUnmarshallers;
    private Map<String, Object> resourceCache;

    public HalClient(ClientConfiguration clientConfiguration, String endpoint, String serviceName, AWSCredentialsProvider awsCredentialsProvider, Map<String, Object> resourceCache) {
        super(clientConfiguration);
        this.setServiceNameIntern(serviceName);
        this.setEndpoint(endpoint);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.exceptionUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.resourceCache = resourceCache;
        this.addRequestHandler(new AcceptHalJsonRequestHandler());
    }

    public <T> T getResource(Class<T> resourceClass, String resourcePath) {
        return this.getResource(null, resourceClass, resourcePath, false);
    }

    public <T> T postResource(Class<T> resourceClass, String resourcePath, Object representation) {
        OptionalJsonResponseHandler<HalResource> responseHandler = new OptionalJsonResponseHandler<HalResource>(HalJsonResourceUnmarshaller.getInstance());
        HalResource halResource = (HalResource)this.invoke(HttpMethodName.POST, resourcePath, representation, (HttpResponseHandler<AmazonWebServiceResponse<T>>)responseHandler);
        Object cachedResource = this.resourceCache.get(resourcePath);
        String halResourcePath = this.getHalResourcePath(halResource, responseHandler);
        if (cachedResource != null && resourcePath.equals(halResourcePath)) {
            HalResourceInvocationHandler invocationHandler = (HalResourceInvocationHandler)Proxy.getInvocationHandler(cachedResource);
            invocationHandler.resourceUpdated(halResource);
            return resourceClass.cast(cachedResource);
        }
        return this.createAndCacheResource(resourceClass, halResourcePath, halResource);
    }

    public <T> T putResource(Class<T> resourceClass, String resourcePath, Object representation) {
        OptionalJsonResponseHandler<HalResource> responseHandler = new OptionalJsonResponseHandler<HalResource>(HalJsonResourceUnmarshaller.getInstance());
        HalResource halResource = (HalResource)this.invoke(HttpMethodName.PUT, resourcePath, representation, (HttpResponseHandler<AmazonWebServiceResponse<T>>)responseHandler);
        Object cachedResource = this.resourceCache.get(resourcePath);
        if (cachedResource != null) {
            HalResourceInvocationHandler invocationHandler = (HalResourceInvocationHandler)Proxy.getInvocationHandler(cachedResource);
            invocationHandler.resourceUpdated(halResource);
            return resourceClass.cast(cachedResource);
        }
        return this.createAndCacheResource(resourceClass, resourcePath, halResource);
    }

    public <T> T deleteResource(Class<T> resourceClass, String resourcePath) {
        OptionalJsonResponseHandler<HalResource> responseHandler = new OptionalJsonResponseHandler<HalResource>(HalJsonResourceUnmarshaller.getInstance());
        HalResource halResource = (HalResource)this.invoke(HttpMethodName.DELETE, resourcePath, null, (HttpResponseHandler<AmazonWebServiceResponse<T>>)responseHandler);
        Object cachedResource = this.resourceCache.get(resourcePath);
        if (cachedResource != null) {
            HalResourceInvocationHandler invocationHandler = (HalResourceInvocationHandler)Proxy.getInvocationHandler(cachedResource);
            invocationHandler.resourceUpdated(null);
            this.resourceCache.remove(resourcePath);
        }
        return this.createResource(resourceClass, resourcePath, halResource);
    }

    <T> T getResource(HalResource sourceResource, Class<T> resourceClass, String resourcePath, boolean lazy) {
        if (this.resourceCache.containsKey(resourcePath)) {
            return resourceClass.cast(this.resourceCache.get(resourcePath));
        }
        HalResource halResource = sourceResource != null && sourceResource.getEmbedded().containsKey(resourcePath) ? sourceResource.getEmbedded().get(resourcePath) : (lazy ? null : this.getHalResource(resourcePath));
        return this.createAndCacheResource(resourceClass, resourcePath, halResource);
    }

    HalResource getHalResource(String resourcePath) {
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)HalJsonResourceUnmarshaller.getInstance());
        return (HalResource)this.invoke(HttpMethodName.GET, resourcePath, null, (HttpResponseHandler)responseHandler);
    }

    private <T> T invoke(HttpMethodName httpMethodName, String resourcePath, Object representation, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler) throws AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request request = this.buildRequest(httpMethodName, resourcePath, representation);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        Response response = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        awsRequestMetrics.log();
        return (T)response.getAwsResponse();
    }

    private Request buildRequest(HttpMethodName httpMethodName, String resourcePath, Object representation) {
        DefaultRequest request = new DefaultRequest(null);
        request.setHttpMethod(httpMethodName);
        request.setEndpoint(this.endpoint);
        this.populateResourcePathAndParameters((Request)request, resourcePath);
        if (representation != null) {
            this.assignContent((Request)request, representation);
        }
        return request;
    }

    private void populateResourcePathAndParameters(Request request, String resourcePath) {
        int questionIndex = resourcePath.indexOf("?");
        if (questionIndex < 0) {
            request.setResourcePath(resourcePath);
            return;
        }
        request.setResourcePath(resourcePath.substring(0, questionIndex));
        for (String parameterPair : resourcePath.substring(questionIndex + 1).split("&")) {
            int equalIndex = parameterPair.indexOf("=");
            if (equalIndex < 0) {
                request.addParameter(URLDecoder.decode(parameterPair), null);
                continue;
            }
            request.addParameter(URLDecoder.decode(parameterPair.substring(0, equalIndex)), URLDecoder.decode(parameterPair.substring(equalIndex + 1)));
        }
    }

    private void assignContent(Request request, Object representation) {
        String contentString = new JSONObject(representation).toString();
        if (contentString == null) {
            throw new AmazonClientException("Unable to marshall representation to JSON: " + representation);
        }
        try {
            byte[] contentBytes = contentString.getBytes("UTF-8");
            request.setContent((InputStream)new StringInputStream(contentString));
            request.addHeader("Content-Length", Integer.toString(contentBytes.length));
            request.addHeader("Content-Type", "application/json");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    private <T> T createAndCacheResource(Class<T> resourceClass, String resourcePath, HalResource halResource) {
        T t = this.createResource(resourceClass, resourcePath, halResource);
        this.resourceCache.put(resourcePath, t);
        return t;
    }

    private <T> T createResource(Class<T> resourceClass, String resourcePath, HalResource halResource) {
        Object proxy = Proxy.newProxyInstance(resourceClass.getClassLoader(), new Class[]{resourceClass}, (InvocationHandler)new HalResourceInvocationHandler(halResource, resourcePath, this));
        return resourceClass.cast(proxy);
    }

    private String getHalResourcePath(HalResource halResource, OptionalJsonResponseHandler<HalResource> responseHandler) {
        String resourcePath;
        if (halResource != null && halResource.isDefined()) {
            resourcePath = halResource._getSelfHref();
        } else {
            String endpointString = this.endpoint.toString();
            String location = responseHandler.getLocation();
            resourcePath = location.startsWith(endpointString) ? location.substring(endpointString.length()) : location;
        }
        return resourcePath;
    }
}

