/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.HalJsonArrayUnmarshaller;
import com.amazonaws.hal.client.HalJsonResourceUnmarshaller;
import com.amazonaws.hal.client.HalResource;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class HalJsonEmbeddedUnmarshaller
implements Unmarshaller<Map<String, HalResource>, JsonUnmarshallerContext> {
    private static HalJsonEmbeddedUnmarshaller instance = new HalJsonEmbeddedUnmarshaller();

    HalJsonEmbeddedUnmarshaller() {
    }

    static HalJsonEmbeddedUnmarshaller getInstance() {
        return instance;
    }

    public Map<String, HalResource> unmarshall(JsonUnmarshallerContext context) throws Exception {
        LinkedHashMap<String, HalResource> embedded = new LinkedHashMap<String, HalResource>();
        JsonToken token = context.getCurrentToken();
        while (token != null && token != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                token = context.nextToken();
                if (token == JsonToken.START_ARRAY) {
                    List<HalResource> halResources = new HalJsonArrayUnmarshaller<HalResource>(HalJsonResourceUnmarshaller.getInstance()).unmarshall(context);
                    for (HalResource halResource : halResources) {
                        embedded.put(halResource._getSelfHref(), halResource);
                    }
                } else {
                    HalResource halResource = HalJsonResourceUnmarshaller.getInstance().unmarshall(context);
                    embedded.put(halResource._getSelfHref(), halResource);
                }
            }
            token = context.nextToken();
        }
        return embedded;
    }
}

