/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.HalLink;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

class HalJsonLinkUnmarshaller
implements Unmarshaller<HalLink, JsonUnmarshallerContext> {
    private static HalJsonLinkUnmarshaller instance = new HalJsonLinkUnmarshaller();

    HalJsonLinkUnmarshaller() {
    }

    static HalJsonLinkUnmarshaller getInstance() {
        return instance;
    }

    public HalLink unmarshall(JsonUnmarshallerContext context) throws Exception {
        HalLink halLink = new HalLink();
        JsonToken token = context.getCurrentToken();
        while (token != null && token != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                if (context.testExpression("href")) {
                    context.nextToken();
                    halLink.setHref(context.readText());
                } else if (context.testExpression("name")) {
                    context.nextToken();
                    halLink.setName(context.readText());
                } else if (context.testExpression("title")) {
                    context.nextToken();
                    halLink.setTitle(context.readText());
                } else if (context.testExpression("templated")) {
                    context.nextToken();
                    halLink.setTemplated(Boolean.valueOf(context.readText()));
                } else if (context.testExpression("deprecation")) {
                    context.nextToken();
                    halLink.setDeprecation(context.readText());
                } else {
                    context.nextToken();
                }
            }
            token = context.nextToken();
        }
        return halLink;
    }
}

