/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.HalJsonArrayUnmarshaller;
import com.amazonaws.hal.client.HalJsonCurieUnmarshaller;
import com.amazonaws.hal.client.HalJsonLinkUnmarshaller;
import com.amazonaws.hal.client.HalLink;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class HalJsonLinksUnmarshaller
implements Unmarshaller<Map<String, HalLink>, JsonUnmarshallerContext> {
    private static HalJsonLinksUnmarshaller instance = new HalJsonLinksUnmarshaller();

    HalJsonLinksUnmarshaller() {
    }

    static HalJsonLinksUnmarshaller getInstance() {
        return instance;
    }

    public Map<String, HalLink> unmarshall(JsonUnmarshallerContext context) throws Exception {
        LinkedHashMap<String, HalLink> links = new LinkedHashMap<String, HalLink>();
        JsonToken token = context.getCurrentToken();
        while (token != null && token != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                if (context.testExpression("curie")) {
                    context.nextToken();
                    HalJsonCurieUnmarshaller.getInstance().unmarshall(context);
                } else {
                    String relation = context.readText();
                    token = context.nextToken();
                    if (token == JsonToken.START_ARRAY) {
                        List<HalLink> halLinks = new HalJsonArrayUnmarshaller<HalLink>(HalJsonLinkUnmarshaller.getInstance()).unmarshall(context);
                        int i = 0;
                        for (HalLink halLink : halLinks) {
                            links.put(relation + "_" + i++, halLink);
                        }
                    } else {
                        links.put(relation, HalJsonLinkUnmarshaller.getInstance().unmarshall(context));
                    }
                }
            }
            token = context.nextToken();
        }
        return links;
    }
}

