/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.HalJsonMapUnmarshaller;
import com.amazonaws.hal.client.JsonUnmarshallerUtil;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.ArrayList;
import java.util.List;

class HalJsonListUnmarshaller
implements Unmarshaller<List<Object>, JsonUnmarshallerContext> {
    private static HalJsonListUnmarshaller instance = new HalJsonListUnmarshaller();

    HalJsonListUnmarshaller() {
    }

    static HalJsonListUnmarshaller getInstance() {
        return instance;
    }

    public List<Object> unmarshall(JsonUnmarshallerContext context) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        JsonToken token = context.getCurrentToken();
        while (token != null && token != JsonToken.END_ARRAY) {
            if (token.isScalarValue()) {
                list.add(JsonUnmarshallerUtil.getObjectForToken(token, context));
            } else if (token == JsonToken.START_OBJECT) {
                context.nextToken();
                list.add(HalJsonMapUnmarshaller.getInstance().unmarshall(context));
            } else if (token == JsonToken.START_ARRAY) {
                context.nextToken();
                list.add(HalJsonListUnmarshaller.getInstance().unmarshall(context));
            }
            token = context.nextToken();
        }
        return list;
    }
}

