/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.HalJsonListUnmarshaller;
import com.amazonaws.hal.client.JsonUnmarshallerUtil;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.HashMap;
import java.util.Map;

class HalJsonMapUnmarshaller
implements Unmarshaller<Map<String, Object>, JsonUnmarshallerContext> {
    private static HalJsonMapUnmarshaller instance = new HalJsonMapUnmarshaller();

    HalJsonMapUnmarshaller() {
    }

    static HalJsonMapUnmarshaller getInstance() {
        return instance;
    }

    public Map<String, Object> unmarshall(JsonUnmarshallerContext context) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JsonToken token = context.getCurrentToken();
        while (token != null && token != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                String property = context.readText();
                token = context.nextToken();
                if (token == JsonToken.START_OBJECT) {
                    context.nextToken();
                    map.put(property, HalJsonMapUnmarshaller.getInstance().unmarshall(context));
                } else if (token == JsonToken.START_ARRAY) {
                    context.nextToken();
                    map.put(property, HalJsonListUnmarshaller.getInstance().unmarshall(context));
                } else {
                    map.put(property, JsonUnmarshallerUtil.getObjectForToken(token, context));
                }
            }
            token = context.nextToken();
        }
        return map;
    }
}

