/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.HalJsonEmbeddedUnmarshaller;
import com.amazonaws.hal.client.HalJsonLinksUnmarshaller;
import com.amazonaws.hal.client.HalJsonListUnmarshaller;
import com.amazonaws.hal.client.HalJsonMapUnmarshaller;
import com.amazonaws.hal.client.HalResource;
import com.amazonaws.hal.client.JsonUnmarshallerUtil;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

class HalJsonResourceUnmarshaller
implements Unmarshaller<HalResource, JsonUnmarshallerContext> {
    private static HalJsonResourceUnmarshaller instance = new HalJsonResourceUnmarshaller();

    HalJsonResourceUnmarshaller() {
    }

    static HalJsonResourceUnmarshaller getInstance() {
        return instance;
    }

    public HalResource unmarshall(JsonUnmarshallerContext context) throws Exception {
        HalResource halResource = new HalResource();
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        while (token != null && token != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                if (context.testExpression("_links")) {
                    context.nextToken();
                    halResource.setLinks(HalJsonLinksUnmarshaller.getInstance().unmarshall(context));
                } else if (context.testExpression("_embedded")) {
                    context.nextToken();
                    halResource.setEmbedded(HalJsonEmbeddedUnmarshaller.getInstance().unmarshall(context));
                } else {
                    String property = context.readText();
                    token = context.nextToken();
                    if (token == JsonToken.START_OBJECT) {
                        context.nextToken();
                        halResource.addProperty(property, HalJsonMapUnmarshaller.getInstance().unmarshall(context));
                    } else if (token == JsonToken.START_ARRAY) {
                        context.nextToken();
                        halResource.addProperty(property, HalJsonListUnmarshaller.getInstance().unmarshall(context));
                    } else {
                        halResource.addProperty(property, JsonUnmarshallerUtil.getObjectForToken(token, context));
                    }
                }
            }
            token = context.nextToken();
        }
        return halResource;
    }
}

