/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.HalClient;
import com.amazonaws.hal.client.HalLink;
import com.amazonaws.hal.client.HalResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class HalLinkList<T>
implements List<T> {
    private List<T> inner;

    HalLinkList(HalResource halResource, String relation, Class<T> type, HalClient halClient) {
        HalLink halLink;
        ArrayList<T> resources = new ArrayList<T>();
        int index = 0;
        while ((halLink = halResource.getLink(this.indexedRelation(relation, index++))) != null) {
            resources.add(halClient.getResource(halResource, type, halLink.getHref(), true));
        }
        if (resources.size() == 0 && (halLink = halResource.getLink(relation)) != null) {
            resources.add(halClient.getResource(halResource, type, halLink.getHref(), true));
        }
        this.inner = Collections.unmodifiableList(resources);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.inner.toArray(a);
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.inner).iterator();
    }

    @Override
    public T get(int index) {
        return this.inner.get(index);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.inner.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.inner.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.inner.subList(fromIndex, toIndex);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    private String indexedRelation(String relation, int index) {
        return relation + "_" + index;
    }
}

