/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.Link;
import com.amazonaws.hal.client.HalClient;
import com.amazonaws.hal.client.HalLink;
import com.amazonaws.hal.client.HalResource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HalLinkMap<T>
implements Map<String, T> {
    private Map<String, T> inner;
    private static Log log = LogFactory.getLog(HalLinkMap.class);

    HalLinkMap(HalResource halResource, String relation, Link.KeyField keyField, Class<T> type, HalClient halClient) {
        String key;
        HalLink halLink;
        HashMap<String, T> resources = new HashMap<String, T>();
        int index = 0;
        String indexedRelation = this.indexedRelation(relation, index);
        while ((halLink = halResource.getLink(indexedRelation)) != null) {
            String string = key = keyField == Link.KeyField.Title ? halLink.getTitle() : halLink.getName();
            if (key == null) {
                log.warn((Object)("No key value for mapped link.  Using '" + indexedRelation + "' instead"));
                resources.put(indexedRelation, halClient.getResource(halResource, type, halLink.getHref(), true));
            } else {
                resources.put(key, halClient.getResource(halResource, type, halLink.getHref(), true));
            }
            indexedRelation = this.indexedRelation(relation, index++);
        }
        if (resources.size() == 0 && (halLink = halResource.getLink(relation)) != null) {
            String string = key = keyField == Link.KeyField.Title ? halLink.getTitle() : halLink.getName();
            if (key == null) {
                log.warn((Object)("No key value for mapped link.  Using '" + relation + "' instead"));
                resources.put(relation, halClient.getResource(halResource, type, halLink.getHref(), true));
            } else {
                resources.put(key, halClient.getResource(halResource, type, halLink.getHref(), true));
            }
        }
        this.inner = Collections.unmodifiableMap(resources);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inner.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(Object key) {
        return this.inner.get(key);
    }

    @Override
    public T put(String key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.inner.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.inner.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.inner.entrySet();
    }

    private String indexedRelation(String relation, int index) {
        return relation + "_" + index;
    }
}

