/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.ResourceInfo;
import com.amazonaws.hal.client.HalLink;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class HalResource
implements ResourceInfo {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, HalLink> links = Collections.emptyMap();
    private Map<String, HalResource> embedded = Collections.emptyMap();

    HalResource() {
    }

    @Override
    public boolean _isLinkAvailable(String relation) {
        return this.links.containsKey(relation);
    }

    @Override
    public Set<String> _getAvailableLinks() {
        return this.links.keySet();
    }

    @Override
    public Object _getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public String _getSelfHref() {
        return this._getLinkHref("self");
    }

    @Override
    public String _getLinkHref(String relation) {
        HalLink link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return link.getHref();
    }

    public String toString() {
        HalLink selfLink = this.getLink("self");
        if (selfLink == null) {
            return "<undefined>";
        }
        return selfLink.getHref();
    }

    Object getProperty(String key) {
        return this.properties.get(key);
    }

    void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    HalLink getLink(String relation) {
        return this.links.get(relation);
    }

    void setLinks(Map<String, HalLink> links) {
        this.links = links;
    }

    Map<String, HalResource> getEmbedded() {
        return this.embedded;
    }

    void setEmbedded(Map<String, HalResource> embedded) {
        this.embedded = embedded;
    }

    boolean isDefined() {
        return this.getLink("self") != null;
    }
}

