/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.Link;
import com.amazonaws.hal.ResourceInfo;
import com.amazonaws.hal.UriValue;
import com.amazonaws.hal.UriVariable;
import com.amazonaws.hal.client.ConversionUtil;
import com.amazonaws.hal.client.ConvertingList;
import com.amazonaws.hal.client.ConvertingMap;
import com.amazonaws.hal.client.HalClient;
import com.amazonaws.hal.client.HalLink;
import com.amazonaws.hal.client.HalLinkList;
import com.amazonaws.hal.client.HalLinkMap;
import com.amazonaws.hal.client.HalResource;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HalResourceInvocationHandler
implements InvocationHandler {
    private HalResource halResource;
    private String resourcePath;
    private HalClient halClient;
    private static Log log = LogFactory.getLog(HalResourceInvocationHandler.class);
    private static final Object[] EMPTY_ARGS = new Object[0];

    HalResourceInvocationHandler(HalResource halResource, String resourcePath, HalClient halClient) {
        this.halResource = halResource;
        this.resourcePath = resourcePath;
        this.halClient = halClient;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.halResource == null || !this.halResource.isDefined()) {
            this.halResource = this.halClient.getHalResource(this.resourcePath);
        }
        try {
            Method resourceInfoMethod = ResourceInfo.class.getMethod(method.getName(), method.getParameterTypes());
            return resourceInfoMethod.invoke((Object)this.halResource, args);
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        Link link = method.getAnnotation(Link.class);
        if (link != null) {
            switch (link.method()) {
                case GET: {
                    if (List.class.isAssignableFrom(method.getReturnType())) {
                        return new HalLinkList(this.halResource, link.relation(), (Class)ConversionUtil.getCollectionType(method.getGenericReturnType(), 0, ResourceInfo.class), this.halClient);
                    }
                    if (Map.class.isAssignableFrom(method.getReturnType())) {
                        return new HalLinkMap(this.halResource, link.relation(), link.keyField(), (Class)ConversionUtil.getCollectionType(method.getGenericReturnType(), 1, ResourceInfo.class), this.halClient);
                    }
                    return this.halClient.getResource(this.halResource, method.getReturnType(), this.getRelationHref(link, args == null ? EMPTY_ARGS : args, method.getParameterAnnotations()), false);
                }
                case POST: {
                    if (args == null) {
                        throw new IllegalArgumentException("POST operations require a representation argument.");
                    }
                    return this.halClient.postResource(method.getReturnType(), this.getRelationHref(link, args, method.getParameterAnnotations()), args[0]);
                }
                case PUT: {
                    if (args == null) {
                        throw new IllegalArgumentException("PUT operations require a representation argument.");
                    }
                    return this.halClient.putResource(method.getReturnType(), this.getRelationHref(link, args, method.getParameterAnnotations()), args[0]);
                }
                case DELETE: {
                    return this.halClient.deleteResource(method.getReturnType(), this.getRelationHref(link, args == null ? EMPTY_ARGS : args, method.getParameterAnnotations()));
                }
            }
            throw new UnsupportedOperationException("Unexpected HTTP method: " + link.method());
        }
        if (method.getName().startsWith("get")) {
            String propertyName = ConversionUtil.getPropertyName(method.getName());
            Object property = this.halResource.getProperty(propertyName);
            Type returnType = method.getGenericReturnType();
            if (returnType instanceof Class) {
                if (!((Class)returnType).isInstance(property)) {
                    property = ConversionUtil.convert(returnType, property);
                    this.halResource.addProperty(propertyName, property);
                }
            } else if (!(property instanceof ConvertingMap) && !(property instanceof ConvertingList) && ((property = ConversionUtil.convert(returnType, property)) instanceof ConvertingMap || property instanceof ConvertingList)) {
                this.halResource.addProperty(propertyName, property);
            }
            return property;
        }
        if (method.getName().equals("toString") && args == null) {
            return this.resourcePath;
        }
        if (method.getName().equals("equals") && args != null && args.length == 1) {
            HalResourceInvocationHandler other;
            try {
                other = (HalResourceInvocationHandler)Proxy.getInvocationHandler(args[0]);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
            return this.resourcePath.equals(other.resourcePath);
        }
        if (method.getName().equals("hashCode") && args == null) {
            return this.resourcePath.hashCode();
        }
        throw new UnsupportedOperationException("Don't know how to handle '" + method.getName() + "'");
    }

    void resourceUpdated(HalResource halResource) {
        this.halResource = halResource;
    }

    private String getRelationHref(Link link, Object[] args, Annotation[][] parameterAnnotations) {
        String href;
        HalLink halLink = this.halResource.getLink(link.relation());
        if (halLink == null) {
            throw new UnsupportedOperationException(link.relation());
        }
        if (halLink.getDeprecation() != null) {
            log.warn((Object)("Link '" + link + "' has been deprecated: " + halLink.getDeprecation()));
        }
        if (halLink.isTemplated()) {
            try {
                int i;
                UriTemplate uriTemplate = UriTemplate.fromTemplate((String)halLink.getHref());
                for (i = 0; i < args.length; ++i) {
                    for (Annotation annotation : parameterAnnotations[i]) {
                        if (annotation.annotationType() != UriVariable.class) continue;
                        UriVariable uriVariable = (UriVariable)annotation;
                        this.assignTemplateValue(uriTemplate, uriVariable.name(), args[i]);
                    }
                }
                for (i = 0; i < link.uriValues().length; ++i) {
                    UriValue uriValue = link.uriValues()[i];
                    this.assignTemplateValue(uriTemplate, uriValue.name(), uriValue.value());
                }
                href = uriTemplate.expand();
            }
            catch (MalformedUriTemplateException | VariableExpansionException e) {
                throw new RuntimeException(e);
            }
        } else {
            href = halLink.getHref();
        }
        return href;
    }

    private void assignTemplateValue(UriTemplate uriTemplate, String variableName, Object value) {
        if (uriTemplate.hasVariable(variableName)) {
            log.warn((Object)String.format("Duplicate assignment to variable %s.  Current = '%s', skipping new value '%s'.", variableName, uriTemplate.get(variableName), value));
            return;
        }
        uriTemplate.set(variableName, value);
    }
}

