/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.transform.JsonUnmarshallerContext;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

class JsonUnmarshallerUtil {
    private JsonUnmarshallerUtil() {
    }

    static Object getObjectForToken(JsonToken token, JsonUnmarshallerContext context) throws IOException {
        switch (token) {
            case VALUE_STRING: {
                return context.getJsonParser().getText();
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return context.getJsonParser().getNumberValue();
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new RuntimeException("We expected a VALUE token but got: " + token);
    }
}

