/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.hal.client;

import com.amazonaws.hal.client.ConversionUtil;
import com.amazonaws.hal.client.ConvertingList;
import com.amazonaws.hal.client.ConvertingMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

class MapBackedInvocationHandler
implements InvocationHandler {
    private Type type;
    private Map map;

    MapBackedInvocationHandler(Type type, Map map) {
        this.type = type;
        this.map = map;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("get")) {
            String propertyName = ConversionUtil.getPropertyName(method.getName());
            Object property = this.map.get(propertyName);
            Type returnType = method.getGenericReturnType();
            if (returnType instanceof Class) {
                if (!((Class)returnType).isInstance(property)) {
                    property = ConversionUtil.convert(returnType, property);
                    this.map.put(propertyName, property);
                }
            } else if (!(property instanceof ConvertingMap) && !(property instanceof ConvertingList) && ((property = ConversionUtil.convert(returnType, property)) instanceof ConvertingMap || property instanceof ConvertingList)) {
                this.map.put(propertyName, property);
            }
            return property;
        }
        if (method.getName().equals("toString")) {
            return "Proxy for type: " + this.type;
        }
        throw new UnsupportedOperationException("Don't know how to handle '" + method.getName() + "'");
    }
}

