/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.AclGrantee;
import com.amazonaws.services.accessanalyzer.model.AclPermission;
import com.amazonaws.services.accessanalyzer.model.transform.S3BucketAclGrantConfigurationMarshaller;
import java.io.Serializable;

public class S3BucketAclGrantConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String permission;
    private AclGrantee grantee;

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public S3BucketAclGrantConfiguration withPermission(String permission) {
        this.setPermission(permission);
        return this;
    }

    public S3BucketAclGrantConfiguration withPermission(AclPermission permission) {
        this.permission = permission.toString();
        return this;
    }

    public void setGrantee(AclGrantee grantee) {
        this.grantee = grantee;
    }

    public AclGrantee getGrantee() {
        return this.grantee;
    }

    public S3BucketAclGrantConfiguration withGrantee(AclGrantee grantee) {
        this.setGrantee(grantee);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPermission() != null) {
            sb.append("Permission: ").append(this.getPermission()).append(",");
        }
        if (this.getGrantee() != null) {
            sb.append("Grantee: ").append(this.getGrantee());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketAclGrantConfiguration)) {
            return false;
        }
        S3BucketAclGrantConfiguration other = (S3BucketAclGrantConfiguration)obj;
        if (other.getPermission() == null ^ this.getPermission() == null) {
            return false;
        }
        if (other.getPermission() != null && !other.getPermission().equals(this.getPermission())) {
            return false;
        }
        if (other.getGrantee() == null ^ this.getGrantee() == null) {
            return false;
        }
        return other.getGrantee() == null || other.getGrantee().equals(this.getGrantee());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPermission() == null ? 0 : this.getPermission().hashCode());
        hashCode = 31 * hashCode + (this.getGrantee() == null ? 0 : this.getGrantee().hashCode());
        return hashCode;
    }

    public S3BucketAclGrantConfiguration clone() {
        try {
            return (S3BucketAclGrantConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3BucketAclGrantConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

