/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.Criterion;
import com.amazonaws.services.accessanalyzer.model.transform.InlineArchiveRuleMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class InlineArchiveRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String ruleName;
    private Map<String, Criterion> filter;

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public InlineArchiveRule withRuleName(String ruleName) {
        this.setRuleName(ruleName);
        return this;
    }

    public Map<String, Criterion> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<String, Criterion> filter) {
        this.filter = filter;
    }

    public InlineArchiveRule withFilter(Map<String, Criterion> filter) {
        this.setFilter(filter);
        return this;
    }

    public InlineArchiveRule addFilterEntry(String key, Criterion value) {
        if (null == this.filter) {
            this.filter = new HashMap<String, Criterion>();
        }
        if (this.filter.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.filter.put(key, value);
        return this;
    }

    public InlineArchiveRule clearFilterEntries() {
        this.filter = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleName() != null) {
            sb.append("RuleName: ").append(this.getRuleName()).append(",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineArchiveRule)) {
            return false;
        }
        InlineArchiveRule other = (InlineArchiveRule)obj;
        if (other.getRuleName() == null ^ this.getRuleName() == null) {
            return false;
        }
        if (other.getRuleName() != null && !other.getRuleName().equals(this.getRuleName())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        return other.getFilter() == null || other.getFilter().equals(this.getFilter());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleName() == null ? 0 : this.getRuleName().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        return hashCode;
    }

    public InlineArchiveRule clone() {
        try {
            return (InlineArchiveRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InlineArchiveRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

