/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ResourceDefinition;
import com.amazonaws.services.cloudformation.model.TemplateConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateGeneratedTemplateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<ResourceDefinition> resources;
    private String generatedTemplateName;
    private String stackName;
    private TemplateConfiguration templateConfiguration;

    public List<ResourceDefinition> getResources() {
        if (this.resources == null) {
            this.resources = new SdkInternalList();
        }
        return this.resources;
    }

    public void setResources(Collection<ResourceDefinition> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new SdkInternalList(resources);
    }

    public CreateGeneratedTemplateRequest withResources(ResourceDefinition ... resources) {
        if (this.resources == null) {
            this.setResources((Collection<ResourceDefinition>)new SdkInternalList(resources.length));
        }
        for (ResourceDefinition ele : resources) {
            this.resources.add((Object)ele);
        }
        return this;
    }

    public CreateGeneratedTemplateRequest withResources(Collection<ResourceDefinition> resources) {
        this.setResources(resources);
        return this;
    }

    public void setGeneratedTemplateName(String generatedTemplateName) {
        this.generatedTemplateName = generatedTemplateName;
    }

    public String getGeneratedTemplateName() {
        return this.generatedTemplateName;
    }

    public CreateGeneratedTemplateRequest withGeneratedTemplateName(String generatedTemplateName) {
        this.setGeneratedTemplateName(generatedTemplateName);
        return this;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getStackName() {
        return this.stackName;
    }

    public CreateGeneratedTemplateRequest withStackName(String stackName) {
        this.setStackName(stackName);
        return this;
    }

    public void setTemplateConfiguration(TemplateConfiguration templateConfiguration) {
        this.templateConfiguration = templateConfiguration;
    }

    public TemplateConfiguration getTemplateConfiguration() {
        return this.templateConfiguration;
    }

    public CreateGeneratedTemplateRequest withTemplateConfiguration(TemplateConfiguration templateConfiguration) {
        this.setTemplateConfiguration(templateConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getGeneratedTemplateName() != null) {
            sb.append("GeneratedTemplateName: ").append(this.getGeneratedTemplateName()).append(",");
        }
        if (this.getStackName() != null) {
            sb.append("StackName: ").append(this.getStackName()).append(",");
        }
        if (this.getTemplateConfiguration() != null) {
            sb.append("TemplateConfiguration: ").append(this.getTemplateConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGeneratedTemplateRequest)) {
            return false;
        }
        CreateGeneratedTemplateRequest other = (CreateGeneratedTemplateRequest)obj;
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getGeneratedTemplateName() == null ^ this.getGeneratedTemplateName() == null) {
            return false;
        }
        if (other.getGeneratedTemplateName() != null && !other.getGeneratedTemplateName().equals(this.getGeneratedTemplateName())) {
            return false;
        }
        if (other.getStackName() == null ^ this.getStackName() == null) {
            return false;
        }
        if (other.getStackName() != null && !other.getStackName().equals(this.getStackName())) {
            return false;
        }
        if (other.getTemplateConfiguration() == null ^ this.getTemplateConfiguration() == null) {
            return false;
        }
        return other.getTemplateConfiguration() == null || other.getTemplateConfiguration().equals(this.getTemplateConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getGeneratedTemplateName() == null ? 0 : this.getGeneratedTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getStackName() == null ? 0 : this.getStackName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateConfiguration() == null ? 0 : this.getTemplateConfiguration().hashCode());
        return hashCode;
    }

    public CreateGeneratedTemplateRequest clone() {
        return (CreateGeneratedTemplateRequest)super.clone();
    }
}

