/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ScannedResource
implements Serializable,
Cloneable {
    private String resourceType;
    private Map<String, String> resourceIdentifier;
    private Boolean managedByStack;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ScannedResource withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public Map<String, String> getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public void setResourceIdentifier(Map<String, String> resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public ScannedResource withResourceIdentifier(Map<String, String> resourceIdentifier) {
        this.setResourceIdentifier(resourceIdentifier);
        return this;
    }

    public ScannedResource addResourceIdentifierEntry(String key, String value) {
        if (null == this.resourceIdentifier) {
            this.resourceIdentifier = new HashMap<String, String>();
        }
        if (this.resourceIdentifier.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.resourceIdentifier.put(key, value);
        return this;
    }

    public ScannedResource clearResourceIdentifierEntries() {
        this.resourceIdentifier = null;
        return this;
    }

    public void setManagedByStack(Boolean managedByStack) {
        this.managedByStack = managedByStack;
    }

    public Boolean getManagedByStack() {
        return this.managedByStack;
    }

    public ScannedResource withManagedByStack(Boolean managedByStack) {
        this.setManagedByStack(managedByStack);
        return this;
    }

    public Boolean isManagedByStack() {
        return this.managedByStack;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.getResourceIdentifier()).append(",");
        }
        if (this.getManagedByStack() != null) {
            sb.append("ManagedByStack: ").append(this.getManagedByStack());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScannedResource)) {
            return false;
        }
        ScannedResource other = (ScannedResource)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceIdentifier() == null ^ this.getResourceIdentifier() == null) {
            return false;
        }
        if (other.getResourceIdentifier() != null && !other.getResourceIdentifier().equals(this.getResourceIdentifier())) {
            return false;
        }
        if (other.getManagedByStack() == null ^ this.getManagedByStack() == null) {
            return false;
        }
        return other.getManagedByStack() == null || other.getManagedByStack().equals(this.getManagedByStack());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIdentifier() == null ? 0 : this.getResourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getManagedByStack() == null ? 0 : this.getManagedByStack().hashCode());
        return hashCode;
    }

    public ScannedResource clone() {
        try {
            return (ScannedResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

