/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.ActivateTypeRequest;
import com.amazonaws.services.cloudformation.model.LoggingConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ActivateTypeRequestMarshaller
implements Marshaller<Request<ActivateTypeRequest>, ActivateTypeRequest> {
    public Request<ActivateTypeRequest> marshall(ActivateTypeRequest activateTypeRequest) {
        LoggingConfig loggingConfig;
        if (activateTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)activateTypeRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ActivateType");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (activateTypeRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)activateTypeRequest.getType()));
        }
        if (activateTypeRequest.getPublicTypeArn() != null) {
            request.addParameter("PublicTypeArn", StringUtils.fromString((String)activateTypeRequest.getPublicTypeArn()));
        }
        if (activateTypeRequest.getPublisherId() != null) {
            request.addParameter("PublisherId", StringUtils.fromString((String)activateTypeRequest.getPublisherId()));
        }
        if (activateTypeRequest.getTypeName() != null) {
            request.addParameter("TypeName", StringUtils.fromString((String)activateTypeRequest.getTypeName()));
        }
        if (activateTypeRequest.getTypeNameAlias() != null) {
            request.addParameter("TypeNameAlias", StringUtils.fromString((String)activateTypeRequest.getTypeNameAlias()));
        }
        if (activateTypeRequest.getAutoUpdate() != null) {
            request.addParameter("AutoUpdate", StringUtils.fromBoolean((Boolean)activateTypeRequest.getAutoUpdate()));
        }
        if ((loggingConfig = activateTypeRequest.getLoggingConfig()) != null) {
            if (loggingConfig.getLogRoleArn() != null) {
                request.addParameter("LoggingConfig.LogRoleArn", StringUtils.fromString((String)loggingConfig.getLogRoleArn()));
            }
            if (loggingConfig.getLogGroupName() != null) {
                request.addParameter("LoggingConfig.LogGroupName", StringUtils.fromString((String)loggingConfig.getLogGroupName()));
            }
        }
        if (activateTypeRequest.getExecutionRoleArn() != null) {
            request.addParameter("ExecutionRoleArn", StringUtils.fromString((String)activateTypeRequest.getExecutionRoleArn()));
        }
        if (activateTypeRequest.getVersionBump() != null) {
            request.addParameter("VersionBump", StringUtils.fromString((String)activateTypeRequest.getVersionBump()));
        }
        if (activateTypeRequest.getMajorVersion() != null) {
            request.addParameter("MajorVersion", StringUtils.fromLong((Long)activateTypeRequest.getMajorVersion()));
        }
        return request;
    }
}

