/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.DetectStackDriftRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DetectStackDriftRequestMarshaller
implements Marshaller<Request<DetectStackDriftRequest>, DetectStackDriftRequest> {
    public Request<DetectStackDriftRequest> marshall(DetectStackDriftRequest detectStackDriftRequest) {
        if (detectStackDriftRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detectStackDriftRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DetectStackDrift");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detectStackDriftRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)detectStackDriftRequest.getStackName()));
        }
        if (detectStackDriftRequest.getLogicalResourceIds().isEmpty() && !((SdkInternalList)detectStackDriftRequest.getLogicalResourceIds()).isAutoConstruct()) {
            request.addParameter("LogicalResourceIds", "");
        }
        if (!detectStackDriftRequest.getLogicalResourceIds().isEmpty() || !((SdkInternalList)detectStackDriftRequest.getLogicalResourceIds()).isAutoConstruct()) {
            SdkInternalList logicalResourceIdsList = (SdkInternalList)detectStackDriftRequest.getLogicalResourceIds();
            int logicalResourceIdsListIndex = 1;
            for (String logicalResourceIdsListValue : logicalResourceIdsList) {
                if (logicalResourceIdsListValue != null) {
                    request.addParameter("LogicalResourceIds.member." + logicalResourceIdsListIndex, StringUtils.fromString((String)logicalResourceIdsListValue));
                }
                ++logicalResourceIdsListIndex;
            }
        }
        return request;
    }
}

